/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator;

import cn.org.atool.fluent.mybatis.generator.MybatisGenerator;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TemplateFile {
    public static final List<TemplateFile> TEMPLATE_FILE_LIST = new ArrayList<TemplateFile>(){
        {
            this.add(new TemplateFile("mapping/TableMapping.java.vm", "mapping/*MP.java"));
            this.add(new TemplateFile("entity/EntityHelper.java.vm", "helper/*EntityHelper.java"));
            this.add(new TemplateFile("query/Query.java.vm", "query/*EntityQuery.java"));
            this.add(new TemplateFile("query/Update.java.vm", "query/*EntityUpdate.java"));
            this.add(new TemplateFile("query/WrapperHelper.java.vm", "query/*EntityWrapperHelper.java"));
            this.add(new TemplateFile("dao/BaseDao.java.vm", "dao/base/*BaseDao.java").setBaseDao(true));
            this.add(new TemplateFile("mapper/Partition.java.vm", "mapper/*PartitionMapper.java").setPartition(true));
            this.add(new TemplateFile("dao/DaoIntf.java.vm", "dao/intf/*Dao.java", TemplateType.Dao));
            this.add(new TemplateFile("dao/DaoImpl.java.vm", "dao/impl/*DaoImpl.java", TemplateType.Dao));
            this.add(new TemplateFile("datamap/TableMap.java.vm", "datamap/table/*TableMap.java", TemplateType.Test));
            this.add(new TemplateFile("datamap/EntityMap.java.vm", "datamap/entity/*EntityMap.java", TemplateType.Test));
            this.add(new TemplateFile("mix/TableMix.java.vm", "mix/*TableMix.java", TemplateType.Test));
        }
    };
    private String template;
    private String fileNameReg;
    private TemplateType templateType = TemplateType.Base;
    private boolean isPartition = false;
    private boolean isBaseDao = false;
    private String fileSubPath;
    private String fileSuffix;
    private String fileName;
    private String templateId;

    public TemplateFile(String template, String fileNameReg) {
        this.template = template;
        this.fileNameReg = fileNameReg;
    }

    public TemplateFile(String template, String fileNameReg, TemplateType templateType) {
        this.template = template;
        this.fileNameReg = fileNameReg;
        this.templateType = templateType;
    }

    public static List<FileOutConfig> parseConfigList(MybatisGenerator generator, Map<String, Object> config) {
        return TEMPLATE_FILE_LIST.stream().filter(template -> !template.isPartition || MybatisGenerator.currTable().isPartition()).map(template -> template.parse(generator, config)).collect(Collectors.toList());
    }

    private FileOutConfig parse(final MybatisGenerator generator, final Map<String, Object> config) {
        return new FileOutConfig("/templates/" + this.template){

            public String outputFile(TableInfo tableInfo) {
                TemplateFile.this.parse(MybatisGenerator.currTable().getWithoutSuffixEntity());
                config.put("withoutSuffixEntity", MybatisGenerator.currTable().getWithoutSuffixEntity());
                config.put("withSuffixEntity", MybatisGenerator.currTable().getWithSuffixEntity());
                String _package = TemplateFile.this.getFilePack(generator.getPackage(TemplateFile.this.templateType));
                config.put("pack" + TemplateFile.this.templateId, _package);
                config.put("file" + TemplateFile.this.templateId, TemplateFile.this.fileName);
                TemplateFile.this.setBaseDaoImports(config);
                return TemplateFile.this.getFullFileName(generator);
            }
        };
    }

    private void setBaseDaoImports(Map<String, Object> config) {
        if (!this.isBaseDao || MybatisGenerator.currTable().getBaseDaoInterfaces().size() == 0) {
            return;
        }
        String imports = MybatisGenerator.currTable().getBaseDaoInterfaces().values().stream().map(item -> "import " + item + ";").collect(Collectors.joining("\n"));
        config.put("baseDaoInterfaceImports", imports);
        String implement = MybatisGenerator.currTable().getBaseDaoInterfaces().keySet().stream().map(item -> {
            item = item.replaceAll("\\$\\{entity\\}", (String)config.get("withSuffixEntity"));
            item = item.replaceAll("\\$\\{update\\}", (String)config.get("fileEntityUpdate"));
            item = item.replaceAll("\\$\\{query\\}", (String)config.get("fileEntityQuery"));
            return item;
        }).collect(Collectors.joining(", "));
        config.put("baseDaoInterfaceImplement", implement);
    }

    private void parse(String entityName) {
        int start = this.fileNameReg.lastIndexOf(47);
        start = start < 0 ? 0 : start;
        int end = this.fileNameReg.indexOf(46);
        end = end < 0 ? this.fileNameReg.length() : end;
        this.fileSubPath = this.fileNameReg.substring(0, start);
        String fileRegName = this.fileNameReg.substring(start + 1, end);
        this.fileSuffix = this.fileNameReg.substring(end + 1);
        this.fileName = fileRegName.replace("*", entityName);
        this.templateId = fileRegName.replace("*", "");
    }

    private String getFilePack(String basePackage) {
        return basePackage + "." + this.fileSubPath.replace('/', '.');
    }

    private String getFullFileName(MybatisGenerator generator) {
        String output = generator.getOutputDir();
        if (this.templateType == TemplateType.Test) {
            output = generator.getTestOutputDir();
        } else if (this.templateType == TemplateType.Dao) {
            output = generator.getDaoOutputDir();
        }
        String parentPath = generator.getPackage(this.templateType).replaceAll("\\.", "/");
        return String.format("%s/%s/%s/%s.%s", output, parentPath, this.fileSubPath, this.fileName, this.fileSuffix);
    }

    public TemplateFile setPartition(boolean isPartition) {
        this.isPartition = isPartition;
        return this;
    }

    public TemplateFile setBaseDao(boolean isBaseDao) {
        this.isBaseDao = isBaseDao;
        return this;
    }

    public static enum TemplateType {
        Base,
        Test,
        Dao;

    }
}

