/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator;

import cn.org.atool.fluent.mybatis.generator.MybatisGenerator;
import cn.org.atool.fluent.mybatis.generator.Table;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TableConvertor {
    private Map<String, Table> tables = new HashMap<String, Table>();
    private String[] prefix;
    private String entitySuffix = "Entity";
    private DataSourceConfig dataSourceConfig;
    private MybatisGenerator mybatisGenerator;
    private List<Class> modelInterface = new ArrayList<Class>();

    public TableConvertor() {
        this.prefix = new String[0];
    }

    public TableConvertor(String ... prefix) {
        this.prefix = prefix;
    }

    public Table table(String tableName, String entityName) {
        Table table = new Table(this, tableName, this.precessEntityName(entityName));
        this.tables.put(tableName, table);
        return table;
    }

    private String precessEntityName(String entityName) {
        if (entityName.endsWith(this.entitySuffix)) {
            return entityName.substring(0, entityName.length() - this.entitySuffix.length());
        }
        return entityName;
    }

    public TableConvertor allTable(Consumer<Table> consumer) {
        this.tables.values().stream().forEach(table -> consumer.accept((Table)table));
        return this;
    }

    public Table table(String tableName) {
        Table table = new Table(this, tableName);
        this.tables.put(tableName, table);
        return table;
    }

    public TableConvertor addTable(Table table) {
        table.setConvertor(this);
        this.tables.put(table.getTableName(), table);
        return this;
    }

    public TableConvertor addTable(String tableName) {
        Table table = new Table(this, tableName);
        this.tables.put(tableName, table);
        return this;
    }

    public TableConvertor addTable(String tableName, boolean isPartition) {
        Table table = new Table(this, tableName);
        if (isPartition) {
            table.isPartition();
        }
        this.tables.put(tableName, table);
        return this;
    }

    public TableConvertor setDataSource(String url, String username, String password) {
        return this.setDataSource(url, username, password, null);
    }

    public TableConvertor setDataSource(String url, String username, String password, ITypeConvert typeConvert) {
        this.dataSourceConfig = MybatisGenerator.buildDataSourceConfig(DbType.MYSQL, "com.mysql.jdbc.Driver", url, username, password, typeConvert);
        return this;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig == null ? this.mybatisGenerator.getDataSourceConfig() : this.dataSourceConfig;
    }

    public TableConvertor addModelInterface(Class klass) {
        this.modelInterface.add(klass);
        return this;
    }

    public String getInterfacePacks() {
        return this.modelInterface.stream().map(klass -> "import " + klass.getName() + ";").collect(Collectors.joining("\n"));
    }

    public String getInterfaceNames() {
        return this.modelInterface.stream().map(Class::getSimpleName).collect(Collectors.joining(", "));
    }

    public Map<String, Table> getTables() {
        return this.tables;
    }

    public TableConvertor setPrefix(String[] prefix) {
        this.prefix = prefix;
        return this;
    }

    public String[] getPrefix() {
        return this.prefix;
    }

    public TableConvertor setEntitySuffix(String entitySuffix) {
        this.entitySuffix = entitySuffix;
        return this;
    }

    public String getEntitySuffix() {
        return this.entitySuffix;
    }

    public TableConvertor setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
        return this;
    }

    public TableConvertor setMybatisGenerator(MybatisGenerator mybatisGenerator) {
        this.mybatisGenerator = mybatisGenerator;
        return this;
    }

    public TableConvertor setModelInterface(List<Class> modelInterface) {
        this.modelInterface = modelInterface;
        return this;
    }

    public List<Class> getModelInterface() {
        return this.modelInterface;
    }
}

