/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator;

import cn.org.atool.fluent.mybatis.generator.TableColumn;
import cn.org.atool.fluent.mybatis.generator.TableConvertor;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Table
implements Comparable<Table> {
    private TableConvertor convertor;
    private final String tableName;
    private String withoutSuffixEntity;
    private String gmtCreateColumn;
    private String gmtModifiedColumn;
    private String logicDeletedColumn;
    private String versionColumn;
    private boolean isPartition = false;
    private String mapperPrefix = "";
    private Map<String, String> baseDaoInterfaces = new HashMap<String, String>();
    private Map<String, TableColumn> columns = new HashMap<String, TableColumn>();

    public Table(String tableName) {
        this.tableName = tableName;
    }

    public Table(TableConvertor convertor, String tableName) {
        this.convertor = convertor;
        this.tableName = tableName;
    }

    public Table(TableConvertor convertor, String tableName, String withoutSuffixEntity) {
        this.convertor = convertor;
        this.tableName = tableName;
        this.withoutSuffixEntity = withoutSuffixEntity;
    }

    public String getWithSuffixEntity() {
        return this.withoutSuffixEntity + this.convertor.getEntitySuffix();
    }

    public Table specColumn(String gmtCreateColumn, String gmtModifiedColumn, String logicDeletedColumn) {
        this.setGmtCreateColumn(gmtCreateColumn);
        this.setGmtModifiedColumn(gmtModifiedColumn);
        this.setLogicDeletedColumn(logicDeletedColumn);
        return this;
    }

    public Table specColumn(String gmtCreateColumn, String gmtModifiedColumn, String logicDeletedColumn, String versionColumn) {
        this.setGmtCreateColumn(gmtCreateColumn);
        this.setGmtModifiedColumn(gmtModifiedColumn);
        this.setLogicDeletedColumn(logicDeletedColumn);
        this.versionColumn = versionColumn;
        return this;
    }

    public Table setGmtCreateColumn(String gmtCreateColumn) {
        if (StringUtils.isEmpty((CharSequence)this.gmtCreateColumn)) {
            this.gmtCreateColumn = gmtCreateColumn;
        }
        return this;
    }

    public Table setGmtModifiedColumn(String gmtModifiedColumn) {
        if (StringUtils.isEmpty((CharSequence)this.gmtModifiedColumn)) {
            this.gmtModifiedColumn = gmtModifiedColumn;
        }
        return this;
    }

    public Table setLogicDeletedColumn(String logicDeletedColumn) {
        if (StringUtils.isEmpty((CharSequence)this.logicDeletedColumn)) {
            this.logicDeletedColumn = logicDeletedColumn;
        }
        return this;
    }

    public Table setVersionColumn(String versionColumn) {
        if (StringUtils.isEmpty((CharSequence)this.versionColumn)) {
            this.versionColumn = versionColumn;
        }
        return this;
    }

    public Map<String, String> findFieldConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("entityPrefixName", this.withoutSuffixEntity);
        config.put("field_gmtCreated", this.gmtCreateColumn);
        config.put("field_gmtModified", this.gmtModifiedColumn);
        config.put("field_logicDeleted", this.logicDeletedColumn);
        config.put("field_version", this.versionColumn);
        return config;
    }

    public Table column(String columnName, IColumnType columnType) {
        this.columns.put(columnName, new TableColumn(columnName, null, columnType));
        return this;
    }

    public Table column(String columnName, String propertyName) {
        this.columns.put(columnName, new TableColumn(columnName, propertyName, null));
        return this;
    }

    public Table exclude(String ... columnNames) {
        for (String column : columnNames) {
            this.columns.put(column, new TableColumn(column).setExclude(true));
        }
        return this;
    }

    public Optional<TableColumn> getColumn(String column) {
        return Optional.ofNullable(this.columns.get(column));
    }

    public IColumnType columnType(String column) {
        return this.getColumn(column).map(TableColumn::getColumnType).orElse(null);
    }

    public String getPropertyNameByColumn(String column) {
        return this.getColumn(column).map(TableColumn::getPropertyName).orElse(null);
    }

    @Override
    public int compareTo(Table table) {
        return this.tableName.compareTo(table.getTableName());
    }

    public Table addBaseDaoInterface(String interfaceName, String interfacePackage) {
        this.baseDaoInterfaces.put(interfaceName, interfacePackage);
        return this;
    }

    public TableConvertor getConvertor() {
        return this.convertor;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWithoutSuffixEntity() {
        return this.withoutSuffixEntity;
    }

    public String getGmtCreateColumn() {
        return this.gmtCreateColumn;
    }

    public String getGmtModifiedColumn() {
        return this.gmtModifiedColumn;
    }

    public String getLogicDeletedColumn() {
        return this.logicDeletedColumn;
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public String getMapperPrefix() {
        return this.mapperPrefix;
    }

    public Map<String, TableColumn> getColumns() {
        return this.columns;
    }

    public Table setConvertor(TableConvertor convertor) {
        this.convertor = convertor;
        return this;
    }

    public Table setWithoutSuffixEntity(String withoutSuffixEntity) {
        this.withoutSuffixEntity = withoutSuffixEntity;
        return this;
    }

    public Table setPartition(boolean isPartition) {
        this.isPartition = isPartition;
        return this;
    }

    public Table setMapperPrefix(String mapperPrefix) {
        this.mapperPrefix = mapperPrefix;
        return this;
    }

    public Table setBaseDaoInterfaces(Map<String, String> baseDaoInterfaces) {
        this.baseDaoInterfaces = baseDaoInterfaces;
        return this;
    }

    public Map<String, String> getBaseDaoInterfaces() {
        return this.baseDaoInterfaces;
    }
}

