/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator;

import cn.org.atool.fluent.mybatis.generator.GenerateObj;
import cn.org.atool.fluent.mybatis.generator.MockFlag;
import cn.org.atool.fluent.mybatis.generator.Table;
import cn.org.atool.fluent.mybatis.generator.TableConvertor;
import cn.org.atool.fluent.mybatis.generator.TemplateFile;
import cn.org.atool.fluent.mybatis.generator.mock.CopyAutoGenerator;
import cn.org.atool.fluent.mybatis.generator.mock.MockConfigBuilder;
import cn.org.atool.fluent.mybatis.generator.mock.MockTableField;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import mockit.Mock;
import mockit.MockUp;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.test4j.module.core.utility.MessageHelper;
import org.test4j.tools.commons.StringHelper;

public class MybatisGenerator {
    private static final Logger log = LoggerFactory.getLogger(MybatisGenerator.class);
    private static ThreadLocal<Table> currTable = new ThreadLocal();
    private String author = "generate code";
    private String outputDir = System.getProperty("user.dir") + "/target/generate/base";
    private String testOutputDir = System.getProperty("user.dir") + "/target/generate/test";
    private String daoOutputDir = System.getProperty("user.dir") + "/target/generate/dao";
    private String basePackage;
    private String daoBasePackage;
    private DataSourceConfig dataSourceConfig;
    private boolean isEntitySetChain = true;
    private IdType idType;

    public MybatisGenerator(String basePackage) {
        this.basePackage = basePackage;
        this.daoBasePackage = basePackage;
    }

    public MybatisGenerator(String basePackage, String daoBasePackage) {
        this.basePackage = basePackage;
        this.daoBasePackage = daoBasePackage;
    }

    public static Table currTable() {
        return currTable.get();
    }

    public void generate(TableConvertor ... convertors) {
        ArrayList<GenerateObj> generateObjs = new ArrayList<GenerateObj>();
        MybatisGenerator.doMock();
        for (TableConvertor tableConvertor : convertors) {
            tableConvertor.setMybatisGenerator(this);
            ArrayList<Table> list = new ArrayList<Table>();
            list.addAll(tableConvertor.getTables().values());
            Collections.sort(list);
            for (Table table : list) {
                currTable.set(table);
                MessageHelper.info((Object)("begin to generate table:" + table.getTableName()), (Throwable[])new Throwable[0]);
                this.generate(tableConvertor, new String[]{table.getTableName()}, table.getVersionColumn());
                generateObjs.add(GenerateObj.init(table));
                log.info("generate table {} successful.", (Object)table.getTableName());
            }
        }
        currTable.remove();
        GenerateObj.generate(generateObjs, this.outputDir, this.testOutputDir, this.basePackage);
    }

    public MybatisGenerator setOutputDir(String outputDir, String testOutputDir, String daoOutputDir) {
        if (StringUtils.isNotBlank((CharSequence)outputDir)) {
            this.outputDir = outputDir;
        }
        if (StringUtils.isNotBlank((CharSequence)testOutputDir)) {
            this.testOutputDir = testOutputDir;
        }
        if (StringUtils.isNotBlank((CharSequence)daoOutputDir)) {
            this.daoOutputDir = daoOutputDir;
        }
        return this;
    }

    public MybatisGenerator setDataSource(String url, String username, String password) {
        return this.setDataSource(url, username, password, null);
    }

    public MybatisGenerator setDataSource(String url, String username, String password, ITypeConvert typeConvert) {
        this.dataSourceConfig = MybatisGenerator.buildDataSourceConfig(DbType.MYSQL, "com.mysql.jdbc.Driver", url, username, password, typeConvert);
        return this;
    }

    public static DataSourceConfig buildDataSourceConfig(DbType type, String driver, String url, String username, String password, ITypeConvert typeConvert) {
        if (url == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6570\u636e\u5e93\u94fe\u63a5\u4fe1\u606f url");
        }
        DataSourceConfig config = new DataSourceConfig().setDbType(type).setUrl(url).setUsername(username).setPassword(password).setDriverName(driver);
        if (typeConvert != null) {
            config.setTypeConvert(typeConvert);
        }
        return config;
    }

    private void generate(TableConvertor convertor, String[] tableNames, String verField) {
        new CopyAutoGenerator().setGlobalConfig(this.initGlobalConfig(convertor.getEntitySuffix())).setDataSource(convertor.getDataSourceConfig()).setPackageInfo(this.initPackageConfig()).setTemplate(this.initTemplate()).setStrategy(this.initStrategy(convertor.getPrefix(), tableNames, verField)).setCfg(this.initInjectConfig(convertor)).execute();
    }

    public String getPackage(TemplateFile.TemplateType type) {
        if (TemplateFile.TemplateType.Dao.equals((Object)type) && this.daoBasePackage != null) {
            return this.daoBasePackage;
        }
        return this.basePackage;
    }

    private GlobalConfig initGlobalConfig(String entitySuffix) {
        GlobalConfig config = new GlobalConfig().setAuthor(this.author).setOutputDir(this.outputDir).setFileOverride(true).setActiveRecord(false).setEnableCache(false).setBaseResultMap(true).setBaseColumnList(true).setDateType(DateType.ONLY_DATE).setOpen(false).setEntityName("%s" + entitySuffix);
        if (this.idType != null) {
            config.setIdType(this.idType);
        }
        return config;
    }

    private InjectionConfig initInjectConfig(TableConvertor convertor) {
        final HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("chainSet", this.isEntitySetChain);
        config.putAll(currTable.get().findFieldConfig());
        if (CollectionUtils.isNotEmpty(convertor.getModelInterface())) {
            config.put("interface", true);
            config.put("interfacePack", convertor.getInterfacePacks());
            config.put("interfaceName", convertor.getInterfaceNames());
        }
        if (!StringHelper.isBlankOrNull((String)MybatisGenerator.currTable().getMapperPrefix())) {
            config.put("mapperPrefix", MybatisGenerator.currTable().getMapperPrefix().trim());
        }
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
                this.setMap(config);
            }
        };
        cfg.setFileOutConfigList(TemplateFile.parseConfigList(this, config));
        GenerateObj.setCurrConfig(config);
        return cfg;
    }

    private StrategyConfig initStrategy(String[] tablePrefix, String[] tables, String verField) {
        StrategyConfig sc = new StrategyConfig();
        sc.setCapitalMode(true).setNaming(NamingStrategy.underline_to_camel).setEntityLombokModel(true).setEntityTableFieldAnnotationEnable(true);
        if (StringUtils.isNotBlank((CharSequence)verField)) {
            sc.setVersionFieldName(verField);
        }
        if (tables != null && tables.length > 0) {
            sc.setInclude(tables);
        }
        if (tablePrefix != null) {
            sc.setTablePrefix(tablePrefix);
        }
        return sc;
    }

    private TemplateConfig initTemplate() {
        TemplateConfig tc = new TemplateConfig();
        tc.setEntity("/templates/entity/Entity.java.vm");
        tc.setMapper("/templates/mapper/Mapper.java.vm");
        tc.setXml(null);
        tc.setController(null);
        tc.setService(null);
        tc.setServiceImpl(null);
        return tc;
    }

    private PackageConfig initPackageConfig() {
        return new PackageConfig().setParent(this.basePackage).setEntity("entity").setService("dao").setServiceImpl("dao.impl");
    }

    private static void doMock() {
        if (MockFlag.flag()) {
            return;
        }
        new MockConfigBuilder();
        new MockTableField();
        new MockUp<MockFlag>(){

            @Mock
            public boolean flag() {
                return true;
            }
        };
    }

    public String getAuthor() {
        return this.author;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getTestOutputDir() {
        return this.testOutputDir;
    }

    public String getDaoOutputDir() {
        return this.daoOutputDir;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getDaoBasePackage() {
        return this.daoBasePackage;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public boolean isEntitySetChain() {
        return this.isEntitySetChain;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public MybatisGenerator setAuthor(String author) {
        this.author = author;
        return this;
    }

    public MybatisGenerator setOutputDir(String outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public MybatisGenerator setTestOutputDir(String testOutputDir) {
        this.testOutputDir = testOutputDir;
        return this;
    }

    public MybatisGenerator setDaoOutputDir(String daoOutputDir) {
        this.daoOutputDir = daoOutputDir;
        return this;
    }

    public MybatisGenerator setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public MybatisGenerator setDaoBasePackage(String daoBasePackage) {
        this.daoBasePackage = daoBasePackage;
        return this;
    }

    public MybatisGenerator setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
        return this;
    }

    public MybatisGenerator setEntitySetChain(boolean isEntitySetChain) {
        this.isEntitySetChain = isEntitySetChain;
        return this;
    }

    public MybatisGenerator setIdType(IdType idType) {
        this.idType = idType;
        return this;
    }
}

