/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator;

import cn.org.atool.fluent.mybatis.generator.Table;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerateObj {
    private String tableName;
    private String withoutSuffixEntity;
    private String camelEntity;
    private String mix;
    private String mixInstance;
    private String mixCleanMethod;
    private String mp;
    private String tableMap;
    private String entityMap;
    static ThreadLocal<Map<String, String>> currConfig = new ThreadLocal();

    public static GenerateObj init(Table table) {
        Map<String, String> config = currConfig.get();
        currConfig.remove();
        GenerateObj obj = new GenerateObj().setTableName(table.getTableName()).setWithoutSuffixEntity(config.get("withoutSuffixEntity")).setMix(config.get("fileTableMix")).setMixCleanMethod(String.format("clean%sTable", config.get("withoutSuffixEntity"))).setMp(config.get("fileMP")).setTableMap(config.get("fileTableMap")).setEntityMap(config.get("fileEntityMap"));
        obj.setCamelEntity(obj.withoutSuffixEntity.substring(0, 1).toLowerCase() + obj.withoutSuffixEntity.substring(1));
        obj.mixInstance = obj.mix.substring(0, 1).toLowerCase() + obj.mix.substring(1);
        if (obj.tableName.startsWith("t_")) {
            obj.tableName = obj.tableName.substring(2);
        }
        return obj;
    }

    public static void setCurrConfig(Map currConfig) {
        GenerateObj.currConfig.set(currConfig);
    }

    public static void generate(List<GenerateObj> objs, String output, String testOutput, String basePackage) {
        VelocityTemplateEngine engine = new VelocityTemplateEngine().init(null);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("basePackage", basePackage);
        config.put("objs", objs);
        String templateDir = "/templates/";
        String srcPackDir = String.format("%s/%s/", output, basePackage.replace('.', '/'));
        String testPackDir = String.format("%s/%s/", testOutput, basePackage.replace('.', '/'));
        try {
            engine.writer(config, templateDir + "mix/Mixes.java.vm", testPackDir + "TableMixes.java");
            engine.writer(config, templateDir + "ITable.java.vm", testPackDir + "ITable.java");
            engine.writer(config, templateDir + "DataSourceScript.java.vm", testPackDir + "DataSourceScript.java");
            engine.writer(config, templateDir + "datamap/TM.java.vm", testPackDir + "datamap/TM.java");
            engine.writer(config, templateDir + "datamap/EM.java.vm", testPackDir + "datamap/EM.java");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWithoutSuffixEntity() {
        return this.withoutSuffixEntity;
    }

    public String getCamelEntity() {
        return this.camelEntity;
    }

    public String getMix() {
        return this.mix;
    }

    public String getMixInstance() {
        return this.mixInstance;
    }

    public String getMixCleanMethod() {
        return this.mixCleanMethod;
    }

    public String getMp() {
        return this.mp;
    }

    public String getTableMap() {
        return this.tableMap;
    }

    public String getEntityMap() {
        return this.entityMap;
    }

    public GenerateObj setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public GenerateObj setWithoutSuffixEntity(String withoutSuffixEntity) {
        this.withoutSuffixEntity = withoutSuffixEntity;
        return this;
    }

    public GenerateObj setCamelEntity(String camelEntity) {
        this.camelEntity = camelEntity;
        return this;
    }

    public GenerateObj setMix(String mix) {
        this.mix = mix;
        return this;
    }

    public GenerateObj setMixInstance(String mixInstance) {
        this.mixInstance = mixInstance;
        return this;
    }

    public GenerateObj setMixCleanMethod(String mixCleanMethod) {
        this.mixCleanMethod = mixCleanMethod;
        return this;
    }

    public GenerateObj setMp(String mp) {
        this.mp = mp;
        return this;
    }

    public GenerateObj setTableMap(String tableMap) {
        this.tableMap = tableMap;
        return this;
    }

    public GenerateObj setEntityMap(String entityMap) {
        this.entityMap = entityMap;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerateObj)) {
            return false;
        }
        GenerateObj other = (GenerateObj)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$withoutSuffixEntity = this.getWithoutSuffixEntity();
        String other$withoutSuffixEntity = other.getWithoutSuffixEntity();
        if (this$withoutSuffixEntity == null ? other$withoutSuffixEntity != null : !this$withoutSuffixEntity.equals(other$withoutSuffixEntity)) {
            return false;
        }
        String this$camelEntity = this.getCamelEntity();
        String other$camelEntity = other.getCamelEntity();
        if (this$camelEntity == null ? other$camelEntity != null : !this$camelEntity.equals(other$camelEntity)) {
            return false;
        }
        String this$mix = this.getMix();
        String other$mix = other.getMix();
        if (this$mix == null ? other$mix != null : !this$mix.equals(other$mix)) {
            return false;
        }
        String this$mixInstance = this.getMixInstance();
        String other$mixInstance = other.getMixInstance();
        if (this$mixInstance == null ? other$mixInstance != null : !this$mixInstance.equals(other$mixInstance)) {
            return false;
        }
        String this$mixCleanMethod = this.getMixCleanMethod();
        String other$mixCleanMethod = other.getMixCleanMethod();
        if (this$mixCleanMethod == null ? other$mixCleanMethod != null : !this$mixCleanMethod.equals(other$mixCleanMethod)) {
            return false;
        }
        String this$mp = this.getMp();
        String other$mp = other.getMp();
        if (this$mp == null ? other$mp != null : !this$mp.equals(other$mp)) {
            return false;
        }
        String this$tableMap = this.getTableMap();
        String other$tableMap = other.getTableMap();
        if (this$tableMap == null ? other$tableMap != null : !this$tableMap.equals(other$tableMap)) {
            return false;
        }
        String this$entityMap = this.getEntityMap();
        String other$entityMap = other.getEntityMap();
        return !(this$entityMap == null ? other$entityMap != null : !this$entityMap.equals(other$entityMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenerateObj;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $withoutSuffixEntity = this.getWithoutSuffixEntity();
        result = result * 59 + ($withoutSuffixEntity == null ? 43 : $withoutSuffixEntity.hashCode());
        String $camelEntity = this.getCamelEntity();
        result = result * 59 + ($camelEntity == null ? 43 : $camelEntity.hashCode());
        String $mix = this.getMix();
        result = result * 59 + ($mix == null ? 43 : $mix.hashCode());
        String $mixInstance = this.getMixInstance();
        result = result * 59 + ($mixInstance == null ? 43 : $mixInstance.hashCode());
        String $mixCleanMethod = this.getMixCleanMethod();
        result = result * 59 + ($mixCleanMethod == null ? 43 : $mixCleanMethod.hashCode());
        String $mp = this.getMp();
        result = result * 59 + ($mp == null ? 43 : $mp.hashCode());
        String $tableMap = this.getTableMap();
        result = result * 59 + ($tableMap == null ? 43 : $tableMap.hashCode());
        String $entityMap = this.getEntityMap();
        result = result * 59 + ($entityMap == null ? 43 : $entityMap.hashCode());
        return result;
    }

    public String toString() {
        return "GenerateObj(tableName=" + this.getTableName() + ", withoutSuffixEntity=" + this.getWithoutSuffixEntity() + ", camelEntity=" + this.getCamelEntity() + ", mix=" + this.getMix() + ", mixInstance=" + this.getMixInstance() + ", mixCleanMethod=" + this.getMixCleanMethod() + ", mp=" + this.getMp() + ", tableMap=" + this.getTableMap() + ", entityMap=" + this.getEntityMap() + ")";
    }
}

