package cn.org.atool.fluentmachine.persistence.demo;

import cn.org.atool.fluentmachine.context.Context;
import cn.org.atool.fluentmachine.context.EventContext;
import cn.org.atool.fluentmachine.interfaces.Action;

import java.util.function.Supplier;

public interface CreateMachineService {
    @Action("产品完成所有批次回调?")
    boolean isReceivedAllProduceCallback(Context<CreatePara> ctx);

    @Action("完成所有批次DSK创建?")
    boolean isFinishAllBatch(Context<CreatePara> ctx);

    @Action("注册SI/DSK生命周期")
    void registerLifecycle(EventContext<CreatePara> ctx);

    @Action("注册SI能力")
    void registerCapability(EventContext<CreatePara> ctx);

    @Action("关联DSK和订单请求关系")
    void relateOrder(Supplier<String> supplier);

    @Action("处理产品批次回调")
    void doneProduceCallback(Supplier<String> supplier);

    @Action("任务圆满完成, 通知milkway")
    void callbackMilkWay(EventContext<CreatePara> ctx);

    @Action("按批次消息创建批量DSK")
    void createByBatch(Supplier<String> supplier);

    @Action("构建DSK批次任务表")
    void buildBatchJobs(EventContext<CreatePara> ctx);

    @Action("参数校验")
    void validateCreate(EventContext<CreatePara> ctx);

    @Action("创建SI")
    void createInstance(EventContext<CreatePara> ctx);

    @Action("发送创建SI异步消息")
    void sendAsyncCreateInstanceMsg(EventContext<CreatePara> ctx);

    @Action("消息广播SI能力规格, milkway消费")
    void sendCapability(EventContext<CreatePara> ctx);

    @Action("发送异步创建DSK批次任务")
    void sendAllBatchJobsMsg(EventContext<CreatePara> ctx);

    @Action("给产品放发送批次DSK规格信息")
    void sendBatchCapability(Supplier<String> supplier);

    @Action("如果是DSK预制模式")
    boolean isReservedMode(Context<CreatePara> ctx);
}