package cn.org.atool.fluentmachine.persistence.demo;

import java.lang.Object;
import java.util.function.Consumer;
import org.test4j.mock.faking.fluent.MocksApply;

public class CreateInstanceMachineTestMocks extends MocksApply {
  /**
   * 全局变量, 方便在测试方法中引用CreateInstanceMachineTestMocks实例
   * 每个测试执行完毕, 本实例中定义的mock行为会被清除
   * 如果想定义全局mock行为, 使用 mocks()方法引用
   */
  public static final CreateInstanceMachineTestMocks mocks = mocks();

  /**
   * @see #CreateMachineService(Object...), 无参模式 
   */
  public final CreateMachineServiceFMockUp CreateMachineService = CreateMachineService();

  /**
   * CreateInstanceMachineTestMocks全局变量, 方便引用每个测试执行完毕, mock行为会被清除
   */
  public static final CreateInstanceMachineTestMocks mocks() {
    return new CreateInstanceMachineTestMocks();
  }

  /**
   *  mock {@link CreateMachineService} 多个方法, 示例代码
   *  <pre>
   *  mocks.CreateMachineService(fake->{
   *       fake.toMockMethod1.restReturn("返回值1","返回值2");
   *       fake.toMockMethod2.restReturn("返回值1","返回值2");
   *  });
   *  </pre>
   *
   *  @param faker   {@link CreateMachineServiceMockUp} 构造
   *  @param targets 指定, 表示对特定CreateMachineService实例进行mock;否则,表示对所有CreateMachineService实例进行mock
   */
  public final CreateInstanceMachineTestMocks CreateMachineService(
      Consumer<CreateMachineServiceFMockUp> faker, Object... targets) {
    return super.apply(faker, new CreateMachineServiceFMockUp(targets));
  }

  /**
   *  mock {@link CreateMachineService} 单个方法, 示例代码
   *  <pre>
   *  mocks.CreateMachineService().toMockMethod1.restReturn("返回值1","返回值2");
   *  </pre>
   *
   *  @param targets 指定, 表示对特定CreateMachineService实例进行mock;否则,表示对所有CreateMachineService实例进行mock
   */
  public final CreateMachineServiceFMockUp CreateMachineService(Object... targets) {
    return new CreateMachineServiceFMockUp(targets);
  }
}
