package cn.org.atool.fluentmachine.persistence.demo;

import cn.org.atool.fluentmachine.AMachine;
import cn.org.atool.fluentmachine.builder.MachineBuilder;
import cn.org.atool.fluentmachine.state.IName;
import lombok.Getter;

import static cn.org.atool.fluentmachine.persistence.demo.CreateInstanceMachine.CreateEvent.*;
import static cn.org.atool.fluentmachine.persistence.demo.CreateInstanceMachine.CreateStatus.*;

public class CreateInstanceMachine extends AMachine<CreateInstanceMachine.CreateStatus, CreateInstanceMachine.CreateEvent, CreatePara> {
    @Getter
    private static CreateInstanceMachine machine;

    private CreateMachineService service;

    public CreateInstanceMachine() {
        super(CreateInstanceMachine.class);
        machine = this;
    }

    @Override
    protected MachineBuilder<CreateStatus, CreateEvent, CreatePara> build() {
        return super.name("fluent-machine-demo")
            .root(START)
            .region(WAIT_BATCH_CREATE_AND_CALLBACK,
                FINISH_ONE_BATCH_CREATED, FINISH_ALL_BATCH_CREATED,
                RECEIVED_ONE_BATCH_CALLBACK, RECEIVED_ALL_BATCH_CALLBACK)
            .external(START, RECEIVED_ORDER, service::validateCreate, service::createInstance, service::sendAsyncCreateInstanceMsg)
            .external(RECEIVED_ORDER, REGISTER_CAPABILITY, ReceivedCreateMsg, service::registerCapability)
            .external(REGISTER_CAPABILITY, REGISTER_LIFECYCLE, service::registerLifecycle, service::sendCapability)
            .choices(c -> c
                .from(REGISTER_LIFECYCLE)
                .when(FINISH_API_TASK, service::isReservedMode)
                .last(CREATE_BATCH_JOB, service::buildBatchJobs))
            .external(CREATE_BATCH_JOB, WAIT_BATCH_CREATE_AND_CALLBACK, service::sendAllBatchJobsMsg)
            .external(WAIT_BATCH_CREATE_AND_CALLBACK, FINISH_API_TASK, service::callbackMilkWay)
            .external(FINISH_API_TASK, FINISH)
            .external(g -> g
                .from(FINISH_ONE_BATCH_CREATED)
                .to(FINISH_ALL_BATCH_CREATED)
                .guard(service::isFinishAllBatch)
                .on(DoneOneBatchCreateJob, service::createByBatch, service::relateOrder, service::sendBatchCapability)
                .perform())
            .external(g -> g
                .from(RECEIVED_ONE_BATCH_CALLBACK).to(RECEIVED_ALL_BATCH_CALLBACK)
                .guard(service::isReceivedAllProduceCallback)
                .on(DoneOneCallbackFromProduce, service::doneProduceCallback)
                .perform())
            ;
    }

    /**
     * 创建instance流程节点状态
     *
     * @author darui.wu
     */
    public enum CreateStatus implements IName {
        START("订单调用创建API"),
        RECEIVED_ORDER("已接收API调用"),
        REGISTER_CAPABILITY("注册实例能力规格"),
        REGISTER_LIFECYCLE("注册生命周期"),
        CREATE_BATCH_JOB("已创建并分发批次任务表"),
        WAIT_BATCH_CREATE_AND_CALLBACK("待分批创建和回调"),
        FINISH_ONE_BATCH_CREATED("完成单个批次创建"),
        FINISH_ALL_BATCH_CREATED("完成所有批次创建"),
        RECEIVED_ONE_BATCH_CALLBACK("收到产品一个批次回调"),
        RECEIVED_ALL_BATCH_CALLBACK("收到产品所有批次回调"),
        FINISH_API_TASK("已完成API任务"),
        FINISH("结束任务");

        @Getter
        private String display;

        CreateStatus(String display) {
            this.display = display;
        }
    }

    /**
     * 创建实例过程事件
     *
     * @author darui.wu
     */
    public enum CreateEvent implements IName {
        ReceivedCreateMsg("接收到内部创建实例异步消息"),
        DoneOneBatchCreateJob("完成一个批次创建"),
        DoneOneCallbackFromProduce("完成一次批次产品回调处理");

        @Getter
        private String display;

        CreateEvent(String display) {
            this.display = display;
        }
    }
}