package cn.org.atool.fluentmachine.persistence.db.mix;

import cn.org.atool.fluentmachine.persistence.db.dm.FluentMachineLogDataMap;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.module.spec.IMix;
import org.test4j.module.spec.annotations.Step;

/**
 * 数据库[fluent_machine_log]表数据准备和校验通用方法
 *
 * @author Powered By Test4J
 */
public class FluentMachineLogTableMix implements IMix {
  @Step("清空表[fluent_machine_log]数据")
  public FluentMachineLogTableMix cleanFluentMachineLogTable() {
    db.table("fluent_machine_log").clean();
    return this;
  }

  @Step("准备表[fluent_machine_log]数据{1}")
  public FluentMachineLogTableMix readyFluentMachineLogTable(FluentMachineLogDataMap data) {
    db.table("fluent_machine_log").insert(data);
    return this;
  }

  @Step("验证表[fluent_machine_log]有全表数据{1}")
  public FluentMachineLogTableMix checkFluentMachineLogTable(FluentMachineLogDataMap data,
      EqMode... modes) {
    db.table("fluent_machine_log").query().eqDataMap(data, modes);
    return this;
  }

  @Step("验证表[fluent_machine_log]有符合条件{1}的数据{2}")
  public FluentMachineLogTableMix checkFluentMachineLogTable(String where,
      FluentMachineLogDataMap data, EqMode... modes) {
    db.table("fluent_machine_log").queryWhere(where).eqDataMap(data, modes);
    return this;
  }

  @Step("验证表[fluent_machine_log]有符合条件{1}的数据{2}")
  public FluentMachineLogTableMix checkFluentMachineLogTable(FluentMachineLogDataMap where,
      FluentMachineLogDataMap data, EqMode... modes) {
    db.table("fluent_machine_log").queryWhere(where).eqDataMap(data, modes);
    return this;
  }

  @Step("验证表[fluent_machine_log]有{1}条符合条件{2}的数据")
  public FluentMachineLogTableMix countFluentMachineLogTable(int count,
      FluentMachineLogDataMap where) {
    db.table("fluent_machine_log").queryWhere(where).sizeEq(count);
    return this;
  }

  @Step("验证表[fluent_machine_log]有{1}条符合条件{2}的数据")
  public FluentMachineLogTableMix countFluentMachineLogTable(int count, String where) {
    db.table("fluent_machine_log").queryWhere(where).sizeEq(count);
    return this;
  }

  @Step("验证表[fluent_machine_log]有{1}条数据")
  public FluentMachineLogTableMix countFluentMachineLogTable(int count) {
    db.table("fluent_machine_log").query().sizeEq(count);
    return this;
  }
}