package cn.org.atool.fluentmachine.persistence.db.mix;

import cn.org.atool.fluentmachine.persistence.db.dm.FluentMachineCtxDataMap;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.module.spec.IMix;
import org.test4j.module.spec.annotations.Step;

/**
 * 数据库[fluent_machine_ctx]表数据准备和校验通用方法
 *
 * @author Powered By Test4J
 */
public class FluentMachineCtxTableMix implements IMix {
  @Step("清空表[fluent_machine_ctx]数据")
  public FluentMachineCtxTableMix cleanFluentMachineCtxTable() {
    db.table("fluent_machine_ctx").clean();
    return this;
  }

  @Step("准备表[fluent_machine_ctx]数据{1}")
  public FluentMachineCtxTableMix readyFluentMachineCtxTable(FluentMachineCtxDataMap data) {
    db.table("fluent_machine_ctx").insert(data);
    return this;
  }

  @Step("验证表[fluent_machine_ctx]有全表数据{1}")
  public FluentMachineCtxTableMix checkFluentMachineCtxTable(FluentMachineCtxDataMap data,
      EqMode... modes) {
    db.table("fluent_machine_ctx").query().eqDataMap(data, modes);
    return this;
  }

  @Step("验证表[fluent_machine_ctx]有符合条件{1}的数据{2}")
  public FluentMachineCtxTableMix checkFluentMachineCtxTable(String where,
      FluentMachineCtxDataMap data, EqMode... modes) {
    db.table("fluent_machine_ctx").queryWhere(where).eqDataMap(data, modes);
    return this;
  }

  @Step("验证表[fluent_machine_ctx]有符合条件{1}的数据{2}")
  public FluentMachineCtxTableMix checkFluentMachineCtxTable(FluentMachineCtxDataMap where,
      FluentMachineCtxDataMap data, EqMode... modes) {
    db.table("fluent_machine_ctx").queryWhere(where).eqDataMap(data, modes);
    return this;
  }

  @Step("验证表[fluent_machine_ctx]有{1}条符合条件{2}的数据")
  public FluentMachineCtxTableMix countFluentMachineCtxTable(int count,
      FluentMachineCtxDataMap where) {
    db.table("fluent_machine_ctx").queryWhere(where).sizeEq(count);
    return this;
  }

  @Step("验证表[fluent_machine_ctx]有{1}条符合条件{2}的数据")
  public FluentMachineCtxTableMix countFluentMachineCtxTable(int count, String where) {
    db.table("fluent_machine_ctx").queryWhere(where).sizeEq(count);
    return this;
  }

  @Step("验证表[fluent_machine_ctx]有{1}条数据")
  public FluentMachineCtxTableMix countFluentMachineCtxTable(int count) {
    db.table("fluent_machine_ctx").query().sizeEq(count);
    return this;
  }
}