package cn.org.atool.fluentmachine.persistence.db.dm;

import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.module.database.IDatabase;
import org.test4j.module.database.annotations.ColumnDef;
import org.test4j.module.database.annotations.ScriptTable;
import org.test4j.tools.datagen.DataMap;
import org.test4j.tools.datagen.IDataMap;
import org.test4j.tools.datagen.KeyValue;

import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * FluentMachineLogDataMap: 表(实体)数据对比(插入)构造器
 *
 * @author Powered By Test4J
 */
@ScriptTable("fluent_machine_log")
public class FluentMachineLogDataMap extends DataMap<FluentMachineLogDataMap> {
  private boolean isTable;

  private final Supplier<Boolean> supplier = () -> this.isTable;

  @ColumnDef(
      value = "id",
      type = "bigint(20) unsigned",
      primary = true,
      autoIncrease = true
  )
  public final transient KeyValue<FluentMachineLogDataMap> id = new KeyValue(this, "id", "id", supplier);

  @ColumnDef(
      value = "gmt_modified",
      type = "datetime"
  )
  public final transient KeyValue<FluentMachineLogDataMap> gmtModified = new KeyValue(this, "gmt_modified", "gmtModified", supplier);

  @ColumnDef(
      value = "is_deleted",
      type = "tinyint(2)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> isDeleted = new KeyValue(this, "is_deleted", "isDeleted", supplier);

  @ColumnDef(
      value = "action_errors",
      type = "varchar(3000)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> actionErrors = new KeyValue(this, "action_errors", "actionErrors", supplier);

  @ColumnDef(
      value = "context",
      type = "text"
  )
  public final transient KeyValue<FluentMachineLogDataMap> context = new KeyValue(this, "context", "context", supplier);

  @ColumnDef(
      value = "ctx_state",
      type = "varchar(50)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> ctxState = new KeyValue(this, "ctx_state", "ctxState", supplier);

  @ColumnDef(
      value = "env",
      type = "varchar(20)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> env = new KeyValue(this, "env", "env", supplier);

  @ColumnDef(
      value = "fire_event",
      type = "varchar(50)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> fireEvent = new KeyValue(this, "fire_event", "fireEvent", supplier);

  @ColumnDef(
      value = "gmt_create",
      type = "datetime"
  )
  public final transient KeyValue<FluentMachineLogDataMap> gmtCreate = new KeyValue(this, "gmt_create", "gmtCreate", supplier);

  @ColumnDef(
      value = "machine_id",
      type = "varchar(100)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> machineId = new KeyValue(this, "machine_id", "machineId", supplier);

  @ColumnDef(
      value = "region_states",
      type = "varchar(1000)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> regionStates = new KeyValue(this, "region_states", "regionStates", supplier);

  @ColumnDef(
      value = "source_state",
      type = "varchar(200)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> sourceState = new KeyValue(this, "source_state", "sourceState", supplier);

  @ColumnDef(
      value = "switcher",
      type = "text"
  )
  public final transient KeyValue<FluentMachineLogDataMap> switcher = new KeyValue(this, "switcher", "switcher", supplier);

  @ColumnDef(
      value = "target_state",
      type = "varchar(200)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> targetState = new KeyValue(this, "target_state", "targetState", supplier);

  @ColumnDef(
      value = "trade_no",
      type = "varchar(100)"
  )
  public final transient KeyValue<FluentMachineLogDataMap> tradeNo = new KeyValue(this, "trade_no", "tradeNo", supplier);

  FluentMachineLogDataMap(boolean isTable) {
    super();
    this.isTable = isTable;
  }

  FluentMachineLogDataMap(boolean isTable, int size) {
    super(size);
    this.isTable = isTable;
  }

  /**
   * 创建FluentMachineLogDataMap
   * 初始化主键和gmtCreate, gmtModified, isDeleted等特殊值
   */
  public FluentMachineLogDataMap init() {
    this.id.autoIncrease();
    this.gmtModified.values(new Date());
    this.isDeleted.values(false);
    return this;
  }

  public FluentMachineLogDataMap with(Consumer<FluentMachineLogDataMap> init) {
    init.accept(this);
    return this;
  }

  public static FluentMachineLogDataMap table() {
    return new FluentMachineLogDataMap(true, 1);
  }

  public static FluentMachineLogDataMap table(int size) {
    return new FluentMachineLogDataMap(true, size);
  }

  public static FluentMachineLogDataMap entity() {
    return new FluentMachineLogDataMap(false, 1);
  }

  public static FluentMachineLogDataMap entity(int size) {
    return new FluentMachineLogDataMap(false, size);
  }

  /**
   * DataMap数据和表[fluent_machine_log]数据比较
   */
  public FluentMachineLogDataMap eqTable(EqMode... modes) {
    IDatabase.db.table("fluent_machine_log").query().eqDataMap(this, modes);
    return this;
  }

  /**
   * DataMap数据和表[fluent_machine_log]数据比较
   */
  public FluentMachineLogDataMap eqQuery(String query, EqMode... modes) {
    IDatabase.db.table("fluent_machine_log").queryWhere(query).eqDataMap(this, modes);
    return this;
  }

  /**
   * DataMap数据和表[fluent_machine_log]数据比较
   */
  public FluentMachineLogDataMap eqQuery(IDataMap query, EqMode... modes) {
    IDatabase.db.table("fluent_machine_log").queryWhere(query.map()).eqDataMap(this, modes);
    return this;
  }

  /**
   * 清空[fluent_machine_log]表数据
   */
  public FluentMachineLogDataMap clean() {
    IDatabase.db.cleanTable("fluent_machine_log");
    return this;
  }

  /**
   * 插入[fluent_machine_log]表数据
   */
  public FluentMachineLogDataMap insert() {
    IDatabase.db.table("fluent_machine_log").insert(this);
    return this;
  }

  /**
   * 先清空, 再插入[fluent_machine_log]表数据
   */
  public FluentMachineLogDataMap cleanAndInsert() {
    return this.clean().insert();
  }

  public static class Factory {
    public FluentMachineLogDataMap table() {
      return FluentMachineLogDataMap.table();
    }

    public FluentMachineLogDataMap table(int size) {
      return  FluentMachineLogDataMap.table(size);
    }

    public FluentMachineLogDataMap initTable() {
      return FluentMachineLogDataMap.table().init();
    }

    public FluentMachineLogDataMap initTable(int size) {
      return  FluentMachineLogDataMap.table(size).init();
    }

    public FluentMachineLogDataMap entity() {
      return FluentMachineLogDataMap.entity();
    }

    public FluentMachineLogDataMap entity(int size) {
      return  FluentMachineLogDataMap.entity(size);
    }
  }
}