package cn.org.atool.fluentmachine.persistence.db.dm;

import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.module.database.IDatabase;
import org.test4j.module.database.annotations.ColumnDef;
import org.test4j.module.database.annotations.ScriptTable;
import org.test4j.tools.datagen.DataMap;
import org.test4j.tools.datagen.IDataMap;
import org.test4j.tools.datagen.KeyValue;

import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * FluentMachineCtxDataMap: 表(实体)数据对比(插入)构造器
 *
 * @author Powered By Test4J
 */
@ScriptTable("fluent_machine_ctx")
public class FluentMachineCtxDataMap extends DataMap<FluentMachineCtxDataMap> {
  private boolean isTable;

  private final Supplier<Boolean> supplier = () -> this.isTable;

  @ColumnDef(
      value = "id",
      type = "bigint(20) unsigned",
      primary = true,
      autoIncrease = true
  )
  public final transient KeyValue<FluentMachineCtxDataMap> id = new KeyValue(this, "id", "id", supplier);

  @ColumnDef(
      value = "gmt_modified",
      type = "datetime"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> gmtModified = new KeyValue(this, "gmt_modified", "gmtModified", supplier);

  @ColumnDef(
      value = "is_deleted",
      type = "bigint(20)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> isDeleted = new KeyValue(this, "is_deleted", "isDeleted", supplier);

  @ColumnDef(
      value = "action_errors",
      type = "varchar(3000)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> actionErrors = new KeyValue(this, "action_errors", "actionErrors", supplier);

  @ColumnDef(
      value = "context",
      type = "text"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> context = new KeyValue(this, "context", "context", supplier);

  @ColumnDef(
      value = "ctx_state",
      type = "varchar(50)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> ctxState = new KeyValue(this, "ctx_state", "ctxState", supplier);

  @ColumnDef(
      value = "env",
      type = "varchar(20)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> env = new KeyValue(this, "env", "env", supplier);

  @ColumnDef(
      value = "gmt_create",
      type = "datetime"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> gmtCreate = new KeyValue(this, "gmt_create", "gmtCreate", supplier);

  @ColumnDef(
      value = "lock_expire_time",
      type = "datetime"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> lockExpireTime = new KeyValue(this, "lock_expire_time", "lockExpireTime", supplier);

  @ColumnDef(
      value = "lock_version",
      type = "varchar(50)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> lockVersion = new KeyValue(this, "lock_version", "lockVersion", supplier);

  @ColumnDef(
      value = "machine_id",
      type = "varchar(100)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> machineId = new KeyValue(this, "machine_id", "machineId", supplier);

  @ColumnDef(
      value = "region_states",
      type = "varchar(1000)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> regionStates = new KeyValue(this, "region_states", "regionStates", supplier);

  @ColumnDef(
      value = "switcher",
      type = "text"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> switcher = new KeyValue(this, "switcher", "switcher", supplier);

  @ColumnDef(
      value = "trade_no",
      type = "varchar(100)"
  )
  public final transient KeyValue<FluentMachineCtxDataMap> tradeNo = new KeyValue(this, "trade_no", "tradeNo", supplier);

  FluentMachineCtxDataMap(boolean isTable) {
    super();
    this.isTable = isTable;
  }

  FluentMachineCtxDataMap(boolean isTable, int size) {
    super(size);
    this.isTable = isTable;
  }

  /**
   * 创建FluentMachineCtxDataMap
   * 初始化主键和gmtCreate, gmtModified, isDeleted等特殊值
   */
  public FluentMachineCtxDataMap init() {
    this.id.autoIncrease();
    this.gmtModified.values(new Date());
    this.isDeleted.values(false);
    return this;
  }

  public FluentMachineCtxDataMap with(Consumer<FluentMachineCtxDataMap> init) {
    init.accept(this);
    return this;
  }

  public static FluentMachineCtxDataMap table() {
    return new FluentMachineCtxDataMap(true, 1);
  }

  public static FluentMachineCtxDataMap table(int size) {
    return new FluentMachineCtxDataMap(true, size);
  }

  public static FluentMachineCtxDataMap entity() {
    return new FluentMachineCtxDataMap(false, 1);
  }

  public static FluentMachineCtxDataMap entity(int size) {
    return new FluentMachineCtxDataMap(false, size);
  }

  /**
   * DataMap数据和表[fluent_machine_ctx]数据比较
   */
  public FluentMachineCtxDataMap eqTable(EqMode... modes) {
    IDatabase.db.table("fluent_machine_ctx").query().eqDataMap(this, modes);
    return this;
  }

  /**
   * DataMap数据和表[fluent_machine_ctx]数据比较
   */
  public FluentMachineCtxDataMap eqQuery(String query, EqMode... modes) {
    IDatabase.db.table("fluent_machine_ctx").queryWhere(query).eqDataMap(this, modes);
    return this;
  }

  /**
   * DataMap数据和表[fluent_machine_ctx]数据比较
   */
  public FluentMachineCtxDataMap eqQuery(IDataMap query, EqMode... modes) {
    IDatabase.db.table("fluent_machine_ctx").queryWhere(query.map()).eqDataMap(this, modes);
    return this;
  }

  /**
   * 清空[fluent_machine_ctx]表数据
   */
  public FluentMachineCtxDataMap clean() {
    IDatabase.db.cleanTable("fluent_machine_ctx");
    return this;
  }

  /**
   * 插入[fluent_machine_ctx]表数据
   */
  public FluentMachineCtxDataMap insert() {
    IDatabase.db.table("fluent_machine_ctx").insert(this);
    return this;
  }

  /**
   * 先清空, 再插入[fluent_machine_ctx]表数据
   */
  public FluentMachineCtxDataMap cleanAndInsert() {
    return this.clean().insert();
  }

  public static class Factory {
    public FluentMachineCtxDataMap table() {
      return FluentMachineCtxDataMap.table();
    }

    public FluentMachineCtxDataMap table(int size) {
      return  FluentMachineCtxDataMap.table(size);
    }

    public FluentMachineCtxDataMap initTable() {
      return FluentMachineCtxDataMap.table().init();
    }

    public FluentMachineCtxDataMap initTable(int size) {
      return  FluentMachineCtxDataMap.table(size).init();
    }

    public FluentMachineCtxDataMap entity() {
      return FluentMachineCtxDataMap.entity();
    }

    public FluentMachineCtxDataMap entity(int size) {
      return  FluentMachineCtxDataMap.entity(size);
    }
  }
}