package cn.org.atool.fluentmachine.persistence.db;

import cn.org.atool.fluentmachine.persistence.db.dm.FluentMachineCtxDataMap;
import cn.org.atool.fluentmachine.persistence.db.dm.FluentMachineLogDataMap;
import cn.org.atool.fluentmachine.persistence.db.mix.FluentMachineCtxTableMix;
import cn.org.atool.fluentmachine.persistence.db.mix.FluentMachineLogTableMix;
import org.test4j.module.database.IDataSourceScript;
import org.test4j.module.spec.internal.MixProxy;

import java.util.List;

/**
 * ATM: Application Table Manager
 *
 * @author Powered By Test4J
 */
public interface ATM {
  DataMap dataMap = new DataMap();

  Table table = new Table();

  Mixes mixes = new Mixes();

  /**
   * 应用表名
   */
  class Table {
    public final String fluentMachineLog = "fluent_machine_log";

    public final String fluentMachineCtx = "fluent_machine_ctx";
  }

  /**
   * table or entity data构造器
   */
  class DataMap {
    public final FluentMachineLogDataMap.Factory fluentMachineLog = new FluentMachineLogDataMap.Factory();

    public final FluentMachineCtxDataMap.Factory fluentMachineCtx = new FluentMachineCtxDataMap.Factory();
  }

  /**
   * 应用表数据操作
   */
  class Mixes {
    public final FluentMachineLogTableMix fluentMachineLogTableMix = MixProxy.proxy(FluentMachineLogTableMix.class);

    public final FluentMachineCtxTableMix fluentMachineCtxTableMix = MixProxy.proxy(FluentMachineCtxTableMix.class);

    public void cleanAllTable() {
      this.fluentMachineLogTableMix.cleanFluentMachineLogTable();
      this.fluentMachineCtxTableMix.cleanFluentMachineCtxTable();
    }
  }

  /**
   * 应用数据库创建脚本构造
   */
  class Script implements IDataSourceScript {
    @Override
    public List<Class> getTableKlass() {
      return list(
      	FluentMachineLogDataMap.class,
      	FluentMachineCtxDataMap.class
      );
    }

    @Override
    public IndexList getIndexList() {
      return new IndexList();
    }
  }
}