package cn.org.atool.fluentmachine.persistence;

import cn.org.atool.fluentmachine.context.TradeState;
import cn.org.atool.fluentmachine.saver.ContextSaver;

import javax.sql.DataSource;
import java.util.List;

/**
 * 状态机上下文数据库操作实现
 *
 * @author darui.wu
 */
@SuppressWarnings("unused")
public interface ContextRepository extends ContextSaver {
    String ENV_DEFAULT = "default";
    /**
     * 上下文主表
     */
    String T_FLUENT_MACHINE_CTX = "fluent_machine_ctx";
    /**
     * 上下文操作历史表
     */
    String T_FLUENT_MACHINE_LOG = "fluent_machine_log";


    /**
     * 实例化数据库操作对象,部署环境 default, 表名称默认
     *
     * @param dataSource 状态机存储数据源
     * @return ContextRepository
     */
    static ContextRepository repository(DataSource dataSource) {
        return new ContextRepositoryImpl(ENV_DEFAULT, dataSource, T_FLUENT_MACHINE_CTX, T_FLUENT_MACHINE_LOG);
    }

    /**
     * 实例化数据库操作对象, 表名称默认
     *
     * @param env        部署环境
     * @param dataSource 状态机存储数据源
     * @return ContextRepository
     */
    static ContextRepository repository(String env, DataSource dataSource) {
        return new ContextRepositoryImpl(env, dataSource, T_FLUENT_MACHINE_CTX, T_FLUENT_MACHINE_LOG);
    }

    /**
     * 实例化数据库操作对象, 指定上下文和log的表名称
     *
     * @param env        部署环境
     * @param dataSource 状态机存储数据源
     * @param ctxTable   状态机上下文存储表名称
     * @param logTable   状态机流程log存储标名称
     * @return ContextRepository
     */
    static ContextRepository repository(String env, DataSource dataSource, String ctxTable, String logTable) {
        return new ContextRepositoryImpl(env, dataSource, ctxTable, logTable);
    }

    /**
     * 查询特定状态的上下文列表
     *
     * @param machineId 流程（状态机）标识
     * @param stateId   节点（状态）ID
     * @param id        查询起始id值
     * @param limit     列表大小
     * @return key: context上下文id, value: 对应的trade_no
     */
    List<TradeState> findTradesByStatus(String machineId, String stateId, long id, int limit);

    /**
     * 查找状态机(machineId)超时的列表
     *
     * @param machineId  状态机编号
     * @param minTimeout 最小超时时长设置(开始超时时间, 最小值 10s)
     * @param maxTimeout 最小超时时长设置(开始超时时间, 最小值 60s, 如果为0, 表示不限制(aYear))
     * @param isIn       true: in (states); false: not in (states)
     * @param states     显式设置包含(排除)节点, = null, 表示查找全部
     * @param id         查询起始id值
     * @param limit      列表大小
     * @return 超时业务单号和停留的状态
     */
    List<TradeState> findTimeoutTradeNo(String machineId, long minTimeout, long maxTimeout, boolean isIn, Object[] states, long id, int limit);
}