package cn.org.atool.fluentmachine.persistence;

import lombok.Setter;

/**
 * 状态机json序列化/反序列化工具
 *
 * @author darui.wu
 */
public abstract class JsonKit {
    /**
     * 默认序列化, 反序列化实现
     */
    @Setter
    public static JsonKit kit = new GsonKit();

    /**
     * 对象转换为json string
     *
     * @param src 对象实例
     * @return json string
     */
    public abstract String toJson(Object src);

    /**
     * json string反序列化为对象
     *
     * @param json     json string
     * @param klassOfT 对象类型
     * @param <T>      对象类型
     * @return 反序列化对象
     */
    public abstract <T> T fromJson(String json, Class<T> klassOfT);
}