package cn.org.atool.fluentmachine.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import lombok.Setter;

/**
 * 状态机json序列化/反序列化 gson 实现
 *
 * @author darui.wu
 */
public class GsonKit extends JsonKit {
    @Setter
    private static Gson gson = new GsonBuilder().setObjectToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).create();

    @Override
    public String toJson(Object src) {
        return gson.toJson(src);
    }

    @Override
    public <T> T fromJson(String json, Class<T> klassOfT) {
        return gson.fromJson(json, klassOfT);
    }
}