package cn.org.atool.fluentmachine.persistence;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 状态机上下文
 *
 * @author darui.wu
 */
@Getter
@Setter
@Accessors(chain = true)
public class ContextEntity implements Serializable {
    /**
     * 状态机Id
     */
    private String machineId;
    /**
     * 上下文实例业务主键
     */
    private String tradeNo;
    /**
     * fireEvent 触发路径 source -> target
     */
    private String fireTransit;
    /**
     * 上下文当前所处主状态
     */
    private String ctxState;
    /**
     * 上下文当前所有路径状态
     */
    private String regionStates;
    /**
     * 上下文内容
     */
    private String context;
    /**
     * 错误信息
     */
    private String errors;
    /**
     * 控制开关
     */
    private String switcher;
}