package cn.org.atool.fluentmachine.persistence;

import cn.org.atool.fluentmachine.context.Context;
import cn.org.atool.fluentmachine.context.FireContext;
import cn.org.atool.fluentmachine.saver.ContextSaver;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 上下文保存测试
 *
 * @author darui.wu
 */
public class ContextTestSaver implements ContextSaver {
    private Context context;
    /**
     * 状态机运行路径
     */
    @Getter
    private final List<String> paths = new ArrayList<>();

    @Override
    public boolean isExistContext(String machineId, String tradeNo) {
        return context != null;
    }

    @Override
    public void saveContext(Context context, FireContext fire) {
        this.context = ContextHelper.copy(context);
        this.paths.add(fire.toString());
    }

    @Override
    public boolean lock(Context context, String lockVersion) {
        return true;
    }

    @Override
    public boolean unlock(Context context) {
        return true;
    }

    @Override
    public <DATA> Context<DATA> loadContext(String machineId, String tradeNo, Class<DATA> klass) {
        return this.context;
    }

    /**
     * 返回路径描述
     *
     * @param delimiter 分隔符
     * @return
     */
    public String getPaths(String delimiter) {
        return this.getPaths().stream().collect(Collectors.joining(delimiter));
    }
}