/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.internal.util.MockUtil;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;
import org.objenesis.ObjenesisHelper;

public class StubberImpl
implements Stubber {
    private final Strictness strictness;
    private final List<Answer<?>> answers = new LinkedList();

    public StubberImpl(Strictness strictness) {
        this.strictness = strictness;
    }

    @Override
    public <T> T when(T mock) {
        if (mock == null) {
            throw Reporter.nullPassedToWhenMethod();
        }
        if (!MockUtil.isMock(mock)) {
            throw Reporter.notAMockPassedToWhenMethod();
        }
        MockUtil.getInvocationContainer(mock).setAnswersForStubbing(this.answers, this.strictness);
        return mock;
    }

    @Override
    public Stubber doReturn(Object toBeReturned) {
        return this.doReturnValues(toBeReturned);
    }

    @Override
    public Stubber doReturn(Object toBeReturned, Object ... nextToBeReturned) {
        return this.doReturnValues(toBeReturned).doReturnValues(nextToBeReturned);
    }

    private StubberImpl doReturnValues(Object ... toBeReturned) {
        if (toBeReturned == null) {
            this.answers.add(new Returns(null));
            return this;
        }
        for (Object r : toBeReturned) {
            this.answers.add(new Returns(r));
        }
        return this;
    }

    @Override
    public Stubber doThrow(Throwable ... toBeThrown) {
        if (toBeThrown == null) {
            this.answers.add(new ThrowsException(null));
            return this;
        }
        for (Throwable throwable : toBeThrown) {
            this.answers.add(new ThrowsException(throwable));
        }
        return this;
    }

    @Override
    public Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        if (toBeThrown == null) {
            ThreadSafeMockingProgress.mockingProgress().reset();
            throw Reporter.notAnException();
        }
        Throwable e = null;
        try {
            e = ObjenesisHelper.newInstance(toBeThrown);
        }
        finally {
            if (e == null) {
                ThreadSafeMockingProgress.mockingProgress().reset();
            }
        }
        return this.doThrow(e);
    }

    @Override
    public Stubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... nextToBeThrown) {
        Stubber stubber = this.doThrow(toBeThrown);
        if (nextToBeThrown == null) {
            ThreadSafeMockingProgress.mockingProgress().reset();
            throw Reporter.notAnException();
        }
        for (Class<? extends Throwable> next : nextToBeThrown) {
            stubber = stubber.doThrow(next);
        }
        return stubber;
    }

    @Override
    public Stubber doNothing() {
        this.answers.add(DoesNothing.doesNothing());
        return this;
    }

    @Override
    public Stubber doAnswer(Answer answer) {
        this.answers.add(answer);
        return this;
    }

    @Override
    public Stubber doCallRealMethod() {
        this.answers.add(new CallsRealMethods());
        return this;
    }
}

