/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.List;
import org.assertj.core.api.AbstractSoftAssertions;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

class SoftAssertionsStatement {
    private AbstractSoftAssertions soft;

    private SoftAssertionsStatement(AbstractSoftAssertions soft) {
        this.soft = soft;
    }

    public static Statement softAssertionsStatement(AbstractSoftAssertions softAssertions, Statement baseStatement) {
        return new SoftAssertionsStatement(softAssertions).build(baseStatement);
    }

    private Statement build(final Statement baseStatement) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                baseStatement.evaluate();
                List<Throwable> errors = SoftAssertionsStatement.this.soft.errorsCollected();
                if (errors.isEmpty()) {
                    return;
                }
                AbstractSoftAssertions.tryThrowingMultipleFailuresError(errors);
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }
}

