/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.extended_mockito;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public interface Injector {
    default public void injectByName(Object target, String fieldName, Object toInject) throws NoSuchFieldException, IllegalAccessException {
        NoSuchFieldException error = null;
        for (Class<?> currentTarget = target.getClass(); null != currentTarget; currentTarget = currentTarget.getSuperclass()) {
            try {
                Field field = currentTarget.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(target, toInject);
                return;
            }
            catch (NoSuchFieldException ex) {
                error = ex;
                continue;
            }
        }
        throw error;
    }

    default public void injectByType(Object target, Object ... toInject) throws IllegalAccessException {
        ArrayList<Field> targetFields = new ArrayList<Field>();
        for (Class<?> currentTarget = target.getClass(); null != currentTarget; currentTarget = currentTarget.getSuperclass()) {
            for (Field cur : currentTarget.getDeclaredFields()) {
                targetFields.add(cur);
            }
        }
        Collections.sort(targetFields, (a, b) -> a.getName().compareTo(b.getName()));
        ArrayList<Object> objectsToInject = new ArrayList<Object>();
        for (Object cur : toInject) {
            objectsToInject.add(cur);
        }
        block3: for (Field field : targetFields) {
            if (objectsToInject.isEmpty()) break;
            Iterator it = objectsToInject.iterator();
            while (it.hasNext()) {
                Object injectee = it.next();
                Class<?> targetFieldClass = field.getType();
                if (!targetFieldClass.isInstance(injectee)) continue;
                field.setAccessible(true);
                field.set(target, injectee);
                it.remove();
                continue block3;
            }
        }
    }
}

