/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.BindingPriority;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.StubValue;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.creation.bytebuddy.ByteBuddyCrossClassLoaderSerializationSupport;
import org.mockito.internal.creation.bytebuddy.InterceptedInvocation;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;

public class MockMethodInterceptor
implements Serializable {
    private static final long serialVersionUID = 7152947254057253027L;
    final InternalMockHandler handler;
    private final MockCreationSettings mockCreationSettings;
    private final ByteBuddyCrossClassLoaderSerializationSupport serializationSupport;

    public MockMethodInterceptor(InternalMockHandler handler, MockCreationSettings mockCreationSettings) {
        this.handler = handler;
        this.mockCreationSettings = mockCreationSettings;
        this.serializationSupport = new ByteBuddyCrossClassLoaderSerializationSupport();
    }

    Object doIntercept(Object mock, Method invokedMethod, Object[] arguments, InterceptedInvocation.SuperMethod superMethod) throws Throwable {
        return this.handler.handle(new InterceptedInvocation(mock, this.createMockitoMethod(invokedMethod), arguments, superMethod, SequenceNumber.next()));
    }

    private MockitoMethod createMockitoMethod(Method method) {
        if (this.mockCreationSettings.isSerializable()) {
            return new SerializableMethod(method);
        }
        return new DelegatingMethod(method);
    }

    public MockHandler getMockHandler() {
        return this.handler;
    }

    public ByteBuddyCrossClassLoaderSerializationSupport getSerializationSupport() {
        return this.serializationSupport;
    }

    public static class DispatcherDefaultingToRealMethod {
        @RuntimeType
        @BindingPriority(value=2)
        public static Object interceptSuperCallable(@This Object mock, @FieldValue(value="mockitoInterceptor") MockMethodInterceptor interceptor, @Origin Method invokedMethod, @AllArguments Object[] arguments, @SuperCall(serializableProxy=true) Callable<?> superCall) throws Throwable {
            if (interceptor == null) {
                return superCall.call();
            }
            return interceptor.doIntercept(mock, invokedMethod, arguments, new InterceptedInvocation.SuperMethod.FromCallable(superCall));
        }

        @RuntimeType
        public static Object interceptAbstract(@This Object mock, @FieldValue(value="mockitoInterceptor") MockMethodInterceptor interceptor, @StubValue Object stubValue, @Origin Method invokedMethod, @AllArguments Object[] arguments) throws Throwable {
            if (interceptor == null) {
                return stubValue;
            }
            return interceptor.doIntercept(mock, invokedMethod, arguments, InterceptedInvocation.SuperMethod.IsIllegal.INSTANCE);
        }
    }

    public static class ForWriteReplace {
        public static Object doWriteReplace(@This MockAccess thiz) throws ObjectStreamException {
            return thiz.getMockitoInterceptor().getSerializationSupport().writeReplace(thiz);
        }
    }

    public static class ForEquals {
        public static boolean doIdentityEquals(@This Object thiz, @Argument(value=0) Object other) {
            return thiz == other;
        }
    }

    public static class ForHashCode {
        public static int doIdentityHashCode(@This Object thiz) {
            return System.identityHashCode(thiz);
        }
    }
}

