/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;

public class Percentage {
    public final double value;

    public static Percentage withPercentage(double value) {
        Preconditions.checkNotNull(value);
        Percentage.checkBoundaries(value);
        return new Percentage(value);
    }

    private static void checkBoundaries(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException(String.format("The percentage value <%s> should be > 0.", value));
        }
    }

    private Percentage(double value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percentage other = (Percentage)obj;
        return Objects.areEqual(this.value, other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.value);
        return result;
    }

    public String toString() {
        return this.noFractionalPart() ? String.format("%s%%", (int)this.value) : String.format("%s%%", this.value);
    }

    private boolean noFractionalPart() {
        return this.value % 1.0 == 0.0;
    }
}

