/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.extended_mockito;

import com.github.aro_tech.extended_mockito.MatchersMixin;
import org.mockito.InOrder;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.MockitoFramework;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationAfterDelay;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

public interface MockitoMixin
extends MatchersMixin {
    public static final Answer<Object> CALLS_REAL_METHODS = Mockito.CALLS_REAL_METHODS;
    public static final Answer<Object> RETURNS_DEEP_STUBS = Mockito.RETURNS_DEEP_STUBS;
    public static final Answer<Object> RETURNS_DEFAULTS = Mockito.RETURNS_DEFAULTS;
    public static final Answer<Object> RETURNS_MOCKS = Mockito.RETURNS_MOCKS;
    public static final Answer<Object> RETURNS_SELF = Mockito.RETURNS_SELF;
    public static final Answer<Object> RETURNS_SMART_NULLS = Mockito.RETURNS_SMART_NULLS;

    default public VerificationAfterDelay after(long millis) {
        return Mockito.after(millis);
    }

    default public VerificationMode atLeast(int minNumberOfInvocations) {
        return Mockito.atLeast(minNumberOfInvocations);
    }

    default public VerificationMode atLeastOnce() {
        return Mockito.atLeastOnce();
    }

    default public VerificationMode atMost(int maxNumberOfInvocations) {
        return Mockito.atMost(maxNumberOfInvocations);
    }

    default public VerificationMode calls(int wantedNumberOfInvocations) {
        return Mockito.calls(wantedNumberOfInvocations);
    }

    default public <T> void clearInvocations(T ... mocks) {
        Mockito.clearInvocations(mocks);
    }

    default public VerificationMode description(String description) {
        return Mockito.description(description);
    }

    default public Stubber doAnswer(Answer answer) {
        return Mockito.doAnswer(answer);
    }

    default public Stubber doCallRealMethod() {
        return Mockito.doCallRealMethod();
    }

    default public Stubber doNothing() {
        return Mockito.doNothing();
    }

    default public Stubber doReturn(Object toBeReturned) {
        return Mockito.doReturn(toBeReturned);
    }

    default public Stubber doReturn(Object toBeReturned, Object ... toBeReturnedNext) {
        return Mockito.doReturn(toBeReturned, toBeReturnedNext);
    }

    default public Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        return Mockito.doThrow(toBeThrown);
    }

    default public Stubber doThrow(Throwable ... toBeThrown) {
        return Mockito.doThrow(toBeThrown);
    }

    default public Stubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... toBeThrownNext) {
        return Mockito.doThrow(toBeThrown, toBeThrownNext);
    }

    default public MockitoFramework framework() {
        return Mockito.framework();
    }

    default public Object[] ignoreStubs(Object ... mocks) {
        return Mockito.ignoreStubs(mocks);
    }

    default public InOrder inOrder(Object ... mocks) {
        return Mockito.inOrder(mocks);
    }

    default public <T> T mock(Class<T> classToMock) {
        return Mockito.mock(classToMock);
    }

    default public <T> T mock(Class<T> classToMock, Answer defaultAnswer) {
        return Mockito.mock(classToMock, defaultAnswer);
    }

    default public <T> T mock(Class<T> classToMock, MockSettings mockSettings) {
        return Mockito.mock(classToMock, mockSettings);
    }

    default public <T> T mock(Class<T> classToMock, String name) {
        return Mockito.mock(classToMock, name);
    }

    default public MockingDetails mockingDetails(Object toInspect) {
        return Mockito.mockingDetails(toInspect);
    }

    default public VerificationMode never() {
        return Mockito.never();
    }

    default public VerificationMode only() {
        return Mockito.only();
    }

    default public <T> void reset(T ... mocks) {
        Mockito.reset(mocks);
    }

    default public <T> T spy(Class<T> classToSpy) {
        return Mockito.spy(classToSpy);
    }

    default public <T> T spy(T object) {
        return Mockito.spy(object);
    }

    default public VerificationWithTimeout timeout(long millis) {
        return Mockito.timeout(millis);
    }

    default public VerificationMode times(int wantedNumberOfInvocations) {
        return Mockito.times(wantedNumberOfInvocations);
    }

    default public void validateMockitoUsage() {
        Mockito.validateMockitoUsage();
    }

    default public <T> T verify(T mock) {
        return Mockito.verify(mock);
    }

    default public <T> T verify(T mock, VerificationMode mode) {
        return Mockito.verify(mock, mode);
    }

    default public void verifyNoMoreInteractions(Object ... mocks) {
        Mockito.verifyNoMoreInteractions(mocks);
    }

    default public void verifyZeroInteractions(Object ... mocks) {
        Mockito.verifyZeroInteractions(mocks);
    }

    default public <T> OngoingStubbing<T> when(T methodCall) {
        return Mockito.when(methodCall);
    }

    default public MockSettings withSettings() {
        return Mockito.withSettings();
    }
}

