/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.extended_mockito;

import com.github.aro_tech.extended_mockito.LenientOrderListMatcher;
import com.github.aro_tech.extended_mockito.ListMatcher;
import com.github.aro_tech.extended_mockito.MatchersMixin;
import com.github.aro_tech.extended_mockito.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mockito.ArgumentMatcher;

public interface ExtendedMatchers
extends MatchersMixin {
    default public String containsAllOf(final CharSequence ... expectedParts) {
        return this.argThat(new ArgumentMatcher<String>(){

            @Override
            public boolean matches(String argument) {
                return StringUtil.containsAll(argument, expectedParts);
            }

            public String toString() {
                return "{String containing all of: " + StringUtil.charSequenceArrayToString(expectedParts) + "}";
            }
        });
    }

    default public <T> T toStringContainsAllOf(final CharSequence ... expectedParts) {
        return this.argThat(new ArgumentMatcher<T>(){

            @Override
            public boolean matches(T argument) {
                return StringUtil.containsAll(argument, expectedParts);
            }

            public String toString() {
                return "{Object with toString() containing all of: " + StringUtil.charSequenceArrayToString(expectedParts) + "}";
            }
        });
    }

    default public String containsOneOrMoreOf(final CharSequence ... expectedParts) {
        return this.argThat(new ArgumentMatcher<String>(){

            @Override
            public boolean matches(String argument) {
                return StringUtil.containsOneOrMoreOf(argument, expectedParts);
            }

            public String toString() {
                return "{String containing one or more of: " + StringUtil.charSequenceArrayToString(expectedParts) + "}";
            }
        });
    }

    default public <T> T toStringContainsOneOrMoreOf(final CharSequence ... expectedParts) {
        return this.argThat(new ArgumentMatcher<T>(){

            @Override
            public boolean matches(T argument) {
                return StringUtil.containsOneOrMoreOf(argument, expectedParts);
            }

            public String toString() {
                return "{Object with toString() containing one or more of: " + StringUtil.charSequenceArrayToString(expectedParts) + "}";
            }
        });
    }

    default public <T> List<T> allListItemsMatch(final Predicate<T> predicate) {
        return (List)this.argThat(new ListMatcher<T>(){

            @Override
            protected boolean evaluateStream(Stream<T> stream) {
                return stream.allMatch(predicate);
            }

            public String toString() {
                return "[All items matching the given Predicate]";
            }
        });
    }

    default public <T> List<T> oneOrMoreListItemsMatch(final Predicate<T> predicate) {
        return (List)this.argThat(new ListMatcher<T>(){

            @Override
            protected boolean evaluateStream(Stream<T> stream) {
                return stream.anyMatch(predicate);
            }

            public String toString() {
                return "[One or more items matching the given Predicate]";
            }
        });
    }

    default public <T> List<T> listContainsExactlyInAnyOrder(T ... items) {
        return (List)this.argThat(new LenientOrderListMatcher<T>(items));
    }

    default public <K, V> Map<K, V> mapThat(final Predicate<Map<K, V>> predicate) {
        return (Map)this.argThat(new ArgumentMatcher<Map<K, V>>(){

            @Override
            public boolean matches(Map<K, V> argument) {
                return predicate.test(argument);
            }

            public String toString() {
                return "[Map matching the given Predicate]";
            }
        });
    }

    default public <K, V> Map<K, V> mapThat(final Predicate<Map<K, V>> predicate, final String description) {
        return (Map)this.argThat(new ArgumentMatcher<Map<K, V>>(){

            @Override
            public boolean matches(Map<K, V> argument) {
                return predicate.test(argument);
            }

            public String toString() {
                return description;
            }
        });
    }

    default public <T> Set<T> allSetItemsMatch(final Predicate<T> predicate) {
        return (Set)this.argThat(new ArgumentMatcher<Set<T>>(){

            @Override
            public boolean matches(Set<T> argument) {
                return argument.stream().allMatch(predicate);
            }

            public String toString() {
                return "[All items matching the given Predicate]";
            }
        });
    }

    default public <T> Set<T> oneOrMoreSetItemsMatch(final Predicate<T> predicate) {
        return (Set)this.argThat(new ArgumentMatcher<Set<T>>(){

            @Override
            public boolean matches(Set<T> argument) {
                return argument.stream().anyMatch(predicate);
            }

            public String toString() {
                return "[One or more items matching the given Predicate]";
            }
        });
    }

    default public <T> T objectMatches(Predicate<T> predicate) {
        return this.objectMatches(predicate, "{object matching the given predicate}");
    }

    default public <T> T objectMatches(final Predicate<T> predicate, final String description) {
        return this.argThat(new ArgumentMatcher<T>(){

            @Override
            public boolean matches(Object argument) {
                return predicate.test(argument);
            }

            public String toString() {
                return description;
            }
        });
    }

    default public int intMatches(Predicate<Integer> predicate) {
        return this.intMatches(predicate, "<int matching the given predicate>");
    }

    default public int intMatches(final Predicate<Integer> predicate, final String description) {
        return this.intThat(new ArgumentMatcher<Integer>(){

            @Override
            public boolean matches(Integer argument) {
                return null != argument && predicate.test(Integer.valueOf(argument));
            }

            public String toString() {
                return description;
            }
        });
    }

    default public double doubleMatches(Predicate<Double> predicate) {
        return this.doubleMatches(predicate, "<double matching the given predicate>");
    }

    default public double doubleMatches(final Predicate<Double> predicate, final String description) {
        return this.doubleThat(new ArgumentMatcher<Double>(){

            @Override
            public boolean matches(Double argument) {
                return null != argument && predicate.test(Double.valueOf(argument));
            }

            public String toString() {
                return description;
            }
        });
    }

    default public float floatMatches(Predicate<Float> predicate) {
        return this.floatMatches(predicate, "<float matching the given predicate>");
    }

    default public float floatMatches(final Predicate<Float> predicate, final String description) {
        return this.floatThat(new ArgumentMatcher<Float>(){

            @Override
            public boolean matches(Float argument) {
                return null != argument && predicate.test(Float.valueOf(argument.floatValue()));
            }

            public String toString() {
                return description;
            }
        });
    }

    default public short shortMatches(Predicate<Short> predicate) {
        return this.shortMatches(predicate, "<short matching the given predicate>");
    }

    default public short shortMatches(final Predicate<Short> predicate, final String description) {
        return this.shortThat(new ArgumentMatcher<Short>(){

            @Override
            public boolean matches(Short argument) {
                return null != argument && predicate.test(Short.valueOf(argument));
            }

            public String toString() {
                return description;
            }
        });
    }

    default public long longMatches(Predicate<Long> predicate) {
        return this.longMatches(predicate, "<long matching the given predicate>");
    }

    default public long longMatches(final Predicate<Long> predicate, final String description) {
        return this.longThat(new ArgumentMatcher<Long>(){

            @Override
            public boolean matches(Long argument) {
                return null != argument && predicate.test(Long.valueOf(argument));
            }

            public String toString() {
                return description;
            }
        });
    }

    default public byte byteMatches(Predicate<Byte> predicate) {
        return this.byteMatches(predicate, "<byte matching the given predicate>");
    }

    default public byte byteMatches(final Predicate<Byte> predicate, final String description) {
        return this.byteThat(new ArgumentMatcher<Byte>(){

            @Override
            public boolean matches(Byte argument) {
                return null != argument && predicate.test(Byte.valueOf(argument));
            }

            public String toString() {
                return description;
            }
        });
    }

    default public char charMatches(Predicate<Character> predicate) {
        return this.charMatches(predicate, "<char matching the given predicate>");
    }

    default public char charMatches(final Predicate<Character> predicate, final String description) {
        return this.charThat(new ArgumentMatcher<Character>(){

            @Override
            public boolean matches(Character argument) {
                return null != argument && predicate.test(argument);
            }

            public String toString() {
                return description;
            }
        });
    }

    default public <T> T hasToString(final String expectedToString) {
        return this.argThat(new ArgumentMatcher<T>(){

            @Override
            public boolean matches(T argument) {
                return null != argument && argument.toString().equals(expectedToString);
            }

            public String toString() {
                return "{" + expectedToString + "}";
            }
        });
    }
}

