/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.MethodAspect;
import com.google.inject.internal.State;
import com.google.inject.internal.WeakKeySet;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProvisionListenerBinding;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListenerBinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class InheritingState
implements State {
    private final State parent;
    private final Map<Key<?>, Binding<?>> explicitBindingsMutable = Maps.newLinkedHashMap();
    private final Map<Key<?>, Binding<?>> explicitBindings = Collections.unmodifiableMap(this.explicitBindingsMutable);
    private final Map<Class<? extends Annotation>, ScopeBinding> scopes = Maps.newHashMap();
    private final Set<ProviderLookup<?>> providerLookups = Sets.newLinkedHashSet();
    private final Set<StaticInjectionRequest> staticInjectionRequests = Sets.newLinkedHashSet();
    private final Set<MembersInjectorLookup<?>> membersInjectorLookups = Sets.newLinkedHashSet();
    private final Set<InjectionRequest<?>> injectionRequests = Sets.newLinkedHashSet();
    private final List<TypeConverterBinding> converters = Lists.newArrayList();
    private final List<MethodAspect> methodAspects = Lists.newArrayList();
    private final List<TypeListenerBinding> typeListenerBindings = Lists.newArrayList();
    private final List<ProvisionListenerBinding> provisionListenerBindings = Lists.newArrayList();
    private final List<ModuleAnnotatedMethodScannerBinding> scannerBindings = Lists.newArrayList();
    private final WeakKeySet blacklistedKeys;
    private final Object lock;

    InheritingState(State parent) {
        this.parent = Preconditions.checkNotNull(parent, "parent");
        this.lock = parent == State.NONE ? this : parent.lock();
        this.blacklistedKeys = new WeakKeySet(this.lock);
    }

    @Override
    public State parent() {
        return this.parent;
    }

    @Override
    public <T> BindingImpl<T> getExplicitBinding(Key<T> key) {
        Binding<?> binding = this.explicitBindings.get(key);
        return binding != null ? (BindingImpl<T>)binding : this.parent.getExplicitBinding(key);
    }

    @Override
    public Map<Key<?>, Binding<?>> getExplicitBindingsThisLevel() {
        return this.explicitBindings;
    }

    @Override
    public void putBinding(Key<?> key, BindingImpl<?> binding) {
        this.explicitBindingsMutable.put(key, binding);
    }

    @Override
    public void putProviderLookup(ProviderLookup<?> lookup) {
        this.providerLookups.add(lookup);
    }

    @Override
    public Set<ProviderLookup<?>> getProviderLookupsThisLevel() {
        return this.providerLookups;
    }

    @Override
    public void putStaticInjectionRequest(StaticInjectionRequest staticInjectionRequest) {
        this.staticInjectionRequests.add(staticInjectionRequest);
    }

    @Override
    public Set<StaticInjectionRequest> getStaticInjectionRequestsThisLevel() {
        return this.staticInjectionRequests;
    }

    @Override
    public void putInjectionRequest(InjectionRequest<?> injectionRequest) {
        this.injectionRequests.add(injectionRequest);
    }

    @Override
    public Set<InjectionRequest<?>> getInjectionRequestsThisLevel() {
        return this.injectionRequests;
    }

    @Override
    public void putMembersInjectorLookup(MembersInjectorLookup<?> membersInjectorLookup) {
        this.membersInjectorLookups.add(membersInjectorLookup);
    }

    @Override
    public Set<MembersInjectorLookup<?>> getMembersInjectorLookupsThisLevel() {
        return this.membersInjectorLookups;
    }

    @Override
    public ScopeBinding getScopeBinding(Class<? extends Annotation> annotationType) {
        ScopeBinding scopeBinding = this.scopes.get(annotationType);
        return scopeBinding != null ? scopeBinding : this.parent.getScopeBinding(annotationType);
    }

    @Override
    public void putScopeBinding(Class<? extends Annotation> annotationType, ScopeBinding scope) {
        this.scopes.put(annotationType, scope);
    }

    @Override
    public Collection<ScopeBinding> getScopeBindingsThisLevel() {
        return this.scopes.values();
    }

    @Override
    public Iterable<TypeConverterBinding> getConvertersThisLevel() {
        return this.converters;
    }

    @Override
    public void addConverter(TypeConverterBinding typeConverterBinding) {
        this.converters.add(typeConverterBinding);
    }

    @Override
    public TypeConverterBinding getConverter(String stringValue, TypeLiteral<?> type, Errors errors, Object source) {
        TypeConverterBinding matchingConverter = null;
        for (State s2 = this; s2 != State.NONE; s2 = s2.parent()) {
            for (TypeConverterBinding converter : s2.getConvertersThisLevel()) {
                if (!converter.getTypeMatcher().matches(type)) continue;
                if (matchingConverter != null) {
                    errors.ambiguousTypeConversion(stringValue, source, type, matchingConverter, converter);
                }
                matchingConverter = converter;
            }
        }
        return matchingConverter;
    }

    @Override
    public void addMethodAspect(MethodAspect methodAspect) {
        this.methodAspects.add(methodAspect);
    }

    @Override
    public ImmutableList<MethodAspect> getMethodAspects() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.parent.getMethodAspects())).addAll(this.methodAspects)).build();
    }

    @Override
    public void addTypeListener(TypeListenerBinding listenerBinding) {
        this.typeListenerBindings.add(listenerBinding);
    }

    @Override
    public List<TypeListenerBinding> getTypeListenerBindings() {
        List<TypeListenerBinding> parentBindings = this.parent.getTypeListenerBindings();
        ArrayList<TypeListenerBinding> result = Lists.newArrayListWithCapacity(parentBindings.size() + this.typeListenerBindings.size());
        result.addAll(parentBindings);
        result.addAll(this.typeListenerBindings);
        return result;
    }

    @Override
    public List<TypeListenerBinding> getTypeListenerBindingsThisLevel() {
        return this.typeListenerBindings;
    }

    @Override
    public void addProvisionListener(ProvisionListenerBinding listenerBinding) {
        this.provisionListenerBindings.add(listenerBinding);
    }

    @Override
    public List<ProvisionListenerBinding> getProvisionListenerBindings() {
        List<ProvisionListenerBinding> parentBindings = this.parent.getProvisionListenerBindings();
        ArrayList<ProvisionListenerBinding> result = Lists.newArrayListWithCapacity(parentBindings.size() + this.provisionListenerBindings.size());
        result.addAll(parentBindings);
        result.addAll(this.provisionListenerBindings);
        return result;
    }

    @Override
    public List<ProvisionListenerBinding> getProvisionListenerBindingsThisLevel() {
        return this.provisionListenerBindings;
    }

    @Override
    public void addScanner(ModuleAnnotatedMethodScannerBinding scanner) {
        this.scannerBindings.add(scanner);
    }

    @Override
    public List<ModuleAnnotatedMethodScannerBinding> getScannerBindings() {
        List<ModuleAnnotatedMethodScannerBinding> parentBindings = this.parent.getScannerBindings();
        ArrayList<ModuleAnnotatedMethodScannerBinding> result = Lists.newArrayListWithCapacity(parentBindings.size() + this.scannerBindings.size());
        result.addAll(parentBindings);
        result.addAll(this.scannerBindings);
        return result;
    }

    @Override
    public List<ModuleAnnotatedMethodScannerBinding> getScannerBindingsThisLevel() {
        return this.scannerBindings;
    }

    @Override
    public void blacklist(Key<?> key, State state, Object source) {
        this.parent.blacklist(key, state, source);
        this.blacklistedKeys.add(key, state, source);
    }

    @Override
    public boolean isBlacklisted(Key<?> key) {
        return this.blacklistedKeys.contains(key);
    }

    @Override
    public Set<Object> getSourcesForBlacklistedKey(Key<?> key) {
        return this.blacklistedKeys.getSources(key);
    }

    @Override
    public Object lock() {
        return this.lock;
    }

    @Override
    public Map<Class<? extends Annotation>, Scope> getScopes() {
        ImmutableMap.Builder<Class<? extends Annotation>, Scope> builder = ImmutableMap.builder();
        for (Map.Entry<Class<? extends Annotation>, ScopeBinding> entry : this.scopes.entrySet()) {
            builder.put(entry.getKey(), entry.getValue().getScope());
        }
        return builder.build();
    }
}

