/*
 * Decompiled with CFR 0.152.
 */
package aquality.tracking.integrations.core.utilities;

import aquality.tracking.integrations.core.AqualityUncheckedException;
import aquality.tracking.integrations.core.utilities.FileReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonMapper {
    private JsonMapper() {
    }

    public static <T> T mapFileContent(String filename, Class<T> tClass) {
        String fileContent = FileReader.readResourceFile(filename);
        return JsonMapper.mapStringContent(fileContent, tClass);
    }

    public static <T> T mapStringContent(String content, TypeReference<T> typeReference) {
        try {
            return new ObjectMapper().readValue(content, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new AqualityUncheckedException(String.format("Exception occurred during mapping %n%s%n to %s", content, typeReference.getType()), e);
        }
    }

    public static <T> T mapStringContent(String content, Class<T> tClass) {
        try {
            return new ObjectMapper().readValue(content, tClass);
        }
        catch (JsonProcessingException e) {
            throw new AqualityUncheckedException(String.format("Exception occurred during mapping %n%s%n to %s", content, tClass.getName()), e);
        }
    }

    public static String getJson(Object data) {
        try {
            return new ObjectMapper().writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new AqualityUncheckedException(String.format("Exception occurred during converting %s to JSON", data), e);
        }
    }
}

