/*
 * Decompiled with CFR 0.152.
 */
package aquality.tracking.integrations.core.endpoints.impl;

import aquality.tracking.integrations.core.Configuration;
import aquality.tracking.integrations.core.IHttpClient;
import aquality.tracking.integrations.core.endpoints.ITestRunEndpoints;
import aquality.tracking.integrations.core.endpoints.impl.AqualityTrackingEndpoints;
import aquality.tracking.integrations.core.models.TestRun;
import aquality.tracking.integrations.core.utilities.JsonMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class TestRunEndpoints
extends AqualityTrackingEndpoints
implements ITestRunEndpoints {
    private static final String START_TESTRUN_ENDPOINT = "/api/public/testrun/start";
    private static final String FINISH_TESTRUN_ENDPOINT = "/api/public/testrun/finish";

    @Inject
    protected TestRunEndpoints(Configuration configuration, IHttpClient httpClient) {
        super(configuration, httpClient);
    }

    @Override
    public TestRun startTestRun(int testSuiteId, String buildName, String environment, String executor, String ciBuild, boolean debug) {
        TestRun testRun = new TestRun();
        testRun.setTestSuiteId(testSuiteId);
        testRun.setProjectId(this.getConfiguration().getProjectId());
        testRun.setBuildName(buildName);
        testRun.setExecutionEnvironment(environment);
        testRun.setAuthor(executor);
        testRun.setCiBuild(ciBuild);
        testRun.setDebug(debug ? 1 : 0);
        URI uri = this.buildURI(START_TESTRUN_ENDPOINT);
        String response = this.getHttpClient().sendPOST(uri, this.getHeaders(), JsonMapper.getJson(testRun));
        return JsonMapper.mapStringContent(response, TestRun.class);
    }

    @Override
    public TestRun finishTestRun(final int testRunId) {
        HashMap<String, String> queryParams = new HashMap<String, String>(){
            {
                this.put("project_id", String.valueOf(TestRunEndpoints.this.getConfiguration().getProjectId()));
                this.put("id", String.valueOf(testRunId));
            }
        };
        URI uri = this.buildURI(FINISH_TESTRUN_ENDPOINT, (Map<String, String>)queryParams);
        String response = this.getHttpClient().sendGET(uri, this.getHeaders());
        return JsonMapper.mapStringContent(response, TestRun.class);
    }
}

