/*
 * Decompiled with CFR 0.152.
 */
package aquality.tracking.integrations.core.endpoints.impl;

import aquality.tracking.integrations.core.Configuration;
import aquality.tracking.integrations.core.IHttpClient;
import aquality.tracking.integrations.core.endpoints.ITestResultEndpoints;
import aquality.tracking.integrations.core.endpoints.impl.AqualityTrackingEndpoints;
import aquality.tracking.integrations.core.models.TestResult;
import aquality.tracking.integrations.core.utilities.JsonMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class TestResultEndpoints
extends AqualityTrackingEndpoints
implements ITestResultEndpoints {
    private static final String START_TEST_RESULT_ENDPOINT = "/api/public/test/result/start";
    private static final String FINISH_TEST_RESULT_ENDPOINT = "/api/public/test/result/finish";

    @Inject
    protected TestResultEndpoints(Configuration configuration, IHttpClient httpClient) {
        super(configuration, httpClient);
    }

    @Override
    public TestResult startTestResult(final int testRunId, final int testId) {
        HashMap<String, String> queryParams = new HashMap<String, String>(){
            {
                this.put("project_id", String.valueOf(TestResultEndpoints.this.getConfiguration().getProjectId()));
                this.put("test_run_id", String.valueOf(testRunId));
                this.put("test_id", String.valueOf(testId));
            }
        };
        URI uri = this.buildURI(START_TEST_RESULT_ENDPOINT, (Map<String, String>)queryParams);
        String response = this.getHttpClient().sendGET(uri, this.getHeaders());
        return JsonMapper.mapStringContent(response, TestResult.class);
    }

    @Override
    public TestResult finishTestResult(int testResultId, int finalResultId, String failReason) {
        TestResult testResult = new TestResult();
        testResult.setProjectId(this.getConfiguration().getProjectId());
        testResult.setId(testResultId);
        testResult.setFinalResultId(finalResultId);
        testResult.setFailReason(failReason);
        URI uri = this.buildURI(FINISH_TEST_RESULT_ENDPOINT);
        String response = this.getHttpClient().sendPOST(uri, this.getHeaders(), JsonMapper.getJson(testResult));
        return JsonMapper.mapStringContent(response, TestResult.class);
    }
}

