/*
 * Decompiled with CFR 0.152.
 */
package aquality.tracking.integrations.core.endpoints.impl;

import aquality.tracking.integrations.core.Configuration;
import aquality.tracking.integrations.core.IHttpClient;
import aquality.tracking.integrations.core.endpoints.ITestEndpoints;
import aquality.tracking.integrations.core.endpoints.impl.AqualityTrackingEndpoints;
import aquality.tracking.integrations.core.models.Suite;
import aquality.tracking.integrations.core.models.Test;
import aquality.tracking.integrations.core.utilities.JsonMapper;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;

public class TestEndpoints
extends AqualityTrackingEndpoints
implements ITestEndpoints {
    private static final String CREATE_OR_UPDATE_TEST_ENDPOINT = "/api/public/test/create-or-update";

    @Inject
    protected TestEndpoints(Configuration configuration, IHttpClient httpClient) {
        super(configuration, httpClient);
    }

    @Override
    public Test createOrUpdateTest(String name, List<Suite> suites) {
        Test test = new Test();
        test.setProjectId(this.getConfiguration().getProjectId());
        test.setName(name);
        test.setSuites(suites);
        URI uri = this.buildURI(CREATE_OR_UPDATE_TEST_ENDPOINT);
        String response = this.getHttpClient().sendPOST(uri, this.getHeaders(), JsonMapper.getJson(test));
        return JsonMapper.mapStringContent(response, Test.class);
    }
}

