/*
 * Decompiled with CFR 0.152.
 */
package aquality.tracking.integrations.core.endpoints.impl;

import aquality.tracking.integrations.core.Configuration;
import aquality.tracking.integrations.core.IHttpClient;
import aquality.tracking.integrations.core.endpoints.ISuiteEndpoints;
import aquality.tracking.integrations.core.endpoints.impl.AqualityTrackingEndpoints;
import aquality.tracking.integrations.core.models.Suite;
import aquality.tracking.integrations.core.utilities.JsonMapper;
import java.net.URI;
import javax.inject.Inject;

public class SuiteEndpoints
extends AqualityTrackingEndpoints
implements ISuiteEndpoints {
    private static final String CREATE_OR_UPDATE_ENDPOINT = "/api/public/suite/create-or-update";

    @Inject
    protected SuiteEndpoints(Configuration configuration, IHttpClient httpClient) {
        super(configuration, httpClient);
    }

    @Override
    public Suite createSuite(String name) {
        Suite suite = new Suite();
        suite.setProjectId(this.getConfiguration().getProjectId());
        suite.setName(name);
        URI uri = this.buildURI(CREATE_OR_UPDATE_ENDPOINT);
        String response = this.getHttpClient().sendPOST(uri, this.getHeaders(), JsonMapper.getJson(suite));
        return JsonMapper.mapStringContent(response, Suite.class);
    }
}

