/*
 * Decompiled with CFR 0.152.
 */
package aquality.tracking.integrations.core.endpoints.impl;

import aquality.tracking.integrations.core.AqualityUncheckedException;
import aquality.tracking.integrations.core.Configuration;
import aquality.tracking.integrations.core.IHttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicHeader;

public abstract class AqualityTrackingEndpoints {
    private final Configuration configuration;
    private final IHttpClient httpClient;

    protected AqualityTrackingEndpoints(Configuration configuration, IHttpClient httpClient) {
        this.configuration = configuration;
        this.httpClient = httpClient;
    }

    protected List<Header> getHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new BasicHeader("Accept", "application/json"));
        headers.add(this.getBasicAuthHeader());
        return headers;
    }

    private Header getBasicAuthHeader() {
        String auth = String.format("project:%d:%s", this.configuration.getProjectId(), this.configuration.getToken());
        byte[] encodedAuth = Base64.encodeBase64(auth.getBytes());
        String authHeader = "Basic ".concat(new String(encodedAuth));
        return new BasicHeader("Authorization", authHeader);
    }

    protected URI buildURI(String path) {
        return this.buildURI(path, new HashMap<String, String>());
    }

    protected URI buildURI(String path, Map<String, String> queryParams) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.configuration.getHost());
            uriBuilder.setPath(path);
            queryParams.forEach((param, value) -> uriBuilder.setParameter((String)param, this.encodeParameter((String)value)));
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new AqualityUncheckedException("Exception during building URI", e);
        }
    }

    private String encodeParameter(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new AqualityUncheckedException(String.format("Exception occurred while encoding query parameter: %s", value), e);
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected IHttpClient getHttpClient() {
        return this.httpClient;
    }
}

