/*
 * Decompiled with CFR 0.152.
 */
package aquality.tracking.integrations.core;

import aquality.tracking.integrations.core.AqualityUncheckedException;
import aquality.tracking.integrations.core.IHttpClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AqualityHttpClient
implements IHttpClient {
    @Override
    public String sendGET(URI uri, List<Header> headers) {
        HttpGet request = new HttpGet(uri);
        this.addHeaders(request, headers);
        return this.sendRequest(request);
    }

    @Override
    public String sendPOST(URI uri, List<Header> headers, String body) {
        HttpPost request = new HttpPost(uri);
        this.addHeaders(request, headers);
        try {
            request.setEntity(new StringEntity(body));
        }
        catch (UnsupportedEncodingException e) {
            throw new AqualityUncheckedException(String.format("Exception occurred during set request body:%n%s", body), e);
        }
        return this.sendRequest(request);
    }

    private String sendRequest(HttpUriRequest httpRequest) {
        String response;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse httpResponse = httpClient.execute(httpRequest);){
            this.processStatusLine(httpResponse.getStatusLine());
            response = this.processEntity(httpResponse.getEntity());
        }
        catch (IOException e) {
            throw new AqualityUncheckedException(String.format("Exception occurred during sending request to %s", httpRequest.getURI()), e);
        }
        return response;
    }

    private void addHeaders(HttpRequest request, List<Header> headers) {
        headers.forEach(request::addHeader);
    }

    private void processStatusLine(StatusLine statusLine) {
        int statusCode = statusLine.getStatusCode();
        if (statusCode != 200) {
            throw new AqualityUncheckedException(String.format("Status code: %d", statusCode));
        }
    }

    private String processEntity(HttpEntity httpEntity) {
        try {
            return EntityUtils.toString(httpEntity, StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new AqualityUncheckedException("Exception occurred during processing response entity", e);
        }
    }
}

