/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.logging;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.logging.LogLevel;

public class LocalizedLoggerUtility {
    private LocalizedLoggerUtility() throws InstantiationException {
        throw new InstantiationException("Utility class");
    }

    public static void logByLevel(LogLevel logLevel, String messageKey, Object ... args) {
        switch (logLevel) {
            case DEBUG: {
                AqualityServices.getLocalizedLogger().debug(messageKey, args);
                break;
            }
            case INFO: {
                AqualityServices.getLocalizedLogger().info(messageKey, args);
                break;
            }
            case WARN: {
                AqualityServices.getLocalizedLogger().warn(messageKey, args);
                break;
            }
            case ERROR: {
                AqualityServices.getLocalizedLogger().error(messageKey, args);
                break;
            }
            case FATAL: {
                AqualityServices.getLocalizedLogger().fatal(messageKey, new Throwable(), args);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Localized logging at level [ %s] is not supported.", new Object[]{logLevel}));
            }
        }
    }
}

