/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements.interfaces;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.browser.JavaScript;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import nu.pattern.OpenCV;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Locatable;

public class ByImage
extends By {
    private static boolean wasLibraryLoaded = false;
    private final Mat template;
    private final String description;
    private float threshold = 1.0f - AqualityServices.getConfiguration().getVisualizationConfiguration().getDefaultThreshold();

    private static void loadLibrary() {
        if (!wasLibraryLoaded) {
            OpenCV.loadShared();
            System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
            wasLibraryLoaded = true;
        }
    }

    public ByImage(File file) {
        ByImage.loadLibrary();
        this.description = file.getName();
        this.template = Imgcodecs.imread((String)file.getAbsolutePath(), (int)-1);
    }

    public ByImage(byte[] bytes) {
        ByImage.loadLibrary();
        this.description = String.format("bytes[%d]", bytes.length);
        this.template = Imgcodecs.imdecode((Mat)new MatOfByte(bytes), (int)-1);
    }

    public ByImage setThreshold(float threshold) {
        if (threshold < 0.0f || threshold > 1.0f) {
            throw new IllegalArgumentException("Threshold must be a float between 0 and 1.");
        }
        this.threshold = threshold;
        return this;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public String toString() {
        return String.format("ByImage: %s, size: (width:%d, height:%d)", this.description, this.template.width(), this.template.height());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByImage)) {
            return false;
        }
        ByImage that = (ByImage)((Object)o);
        return this.template.equals(that.template);
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public List<WebElement> findElements(SearchContext context) {
        Mat source = this.getScreenshot(context);
        Mat result = new Mat();
        Imgproc.matchTemplate((Mat)source, (Mat)this.template, (Mat)result, (int)5);
        Core.MinMaxLocResult minMaxLoc = Core.minMaxLoc((Mat)result);
        ArrayList<Point> matchLocations = new ArrayList<Point>();
        for (int matchCounter = Math.abs((result.width() - this.template.width() + 1) * (result.height() - this.template.height() + 1)); matchCounter > 0 && minMaxLoc.maxVal >= (double)this.threshold; --matchCounter) {
            Point matchLocation2 = minMaxLoc.maxLoc;
            matchLocations.add(matchLocation2);
            Imgproc.rectangle((Mat)result, (Point)new Point(matchLocation2.x, matchLocation2.y), (Point)new Point(matchLocation2.x + (double)this.template.cols(), matchLocation2.y + (double)this.template.rows()), (Scalar)new Scalar(0.0, 0.0, 0.0), (int)-1);
            minMaxLoc = Core.minMaxLoc((Mat)result);
        }
        return matchLocations.stream().map(matchLocation -> this.getElementOnPoint((Point)matchLocation, context)).collect(Collectors.toList());
    }

    protected WebElement getElementOnPoint(Point matchLocation, SearchContext context) {
        if (context instanceof Locatable) {
            org.openqa.selenium.Point point = ((Locatable)context).getCoordinates().onPage();
            matchLocation.x += (double)point.getX();
            matchLocation.y += (double)point.getY();
        }
        int centerX = (int)(matchLocation.x + (double)(this.template.width() / 2));
        int centerY = (int)(matchLocation.y + (double)(this.template.height() / 2));
        List elements = (List)AqualityServices.getBrowser().executeScript(JavaScript.GET_ELEMENTS_FROM_POINT, centerX, centerY);
        elements.sort(Comparator.comparingDouble(e -> ByImage.distanceToPoint(matchLocation, e)));
        return (WebElement)elements.get(0);
    }

    protected static double distanceToPoint(Point matchLocation, WebElement element) {
        org.openqa.selenium.Point elementLocation = element.getLocation();
        return Math.sqrt(Math.pow(matchLocation.x - (double)elementLocation.x, 2.0) + Math.pow(matchLocation.y - (double)elementLocation.y, 2.0));
    }

    protected Mat getScreenshot(SearchContext context) {
        byte[] screenshotBytes = context instanceof TakesScreenshot ? (byte[])((TakesScreenshot)context).getScreenshotAs(OutputType.BYTES) : AqualityServices.getBrowser().getScreenshot();
        boolean isBrowserScreenshot = context instanceof WebDriver || !(context instanceof TakesScreenshot);
        Mat source = Imgcodecs.imdecode((Mat)new MatOfByte(screenshotBytes), (int)-1);
        long devicePixelRatio = (Long)AqualityServices.getBrowser().executeScript(JavaScript.GET_DEVICE_PIXEL_RATIO, new Object[0]);
        if (devicePixelRatio != 1L && isBrowserScreenshot) {
            int scaledWidth = (int)((long)source.width() / devicePixelRatio);
            int scaledHeight = (int)((long)source.height() / devicePixelRatio);
            Imgproc.resize((Mat)source, (Mat)source, (Size)new Size((double)scaledWidth, (double)scaledHeight), (double)0.0, (double)0.0, (int)3);
        }
        return source;
    }
}

