/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements.actions;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.core.utilities.IElementActionRetrier;
import aquality.selenium.elements.actions.JsActions;
import aquality.selenium.elements.interfaces.IElement;
import java.util.function.UnaryOperator;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class MouseActions {
    private final IElement element;
    private final String type;
    private final String name;

    public MouseActions(IElement element, String type) {
        this.element = element;
        this.type = type;
        this.name = element.getName();
    }

    public void click() {
        this.infoLoc("loc.clicking");
        new JsActions(this.element, this.type).highlightElement();
        this.performAction(Actions::click);
    }

    public void rightClick() {
        this.infoLoc("loc.clicking.right");
        this.performAction(actions -> actions.contextClick((WebElement)this.element.getElement()));
    }

    public void moveMouseToElement() {
        this.infoLoc("loc.moving");
        this.performAction(actions -> actions);
    }

    public void moveMouseFromElement() {
        this.infoLoc("loc.movingFrom");
        AqualityServices.get(IElementActionRetrier.class).doWithRetry(() -> new Actions((WebDriver)AqualityServices.getBrowser().getDriver()).moveToElement((WebElement)this.element.getElement(), -this.element.getElement().getSize().width, -this.element.getElement().getSize().height).build().perform());
    }

    public void doubleClick() {
        this.infoLoc("loc.clicking.double");
        this.performAction(actions -> actions.doubleClick((WebElement)this.element.getElement()));
    }

    private void performAction(UnaryOperator<Actions> function) {
        Actions actions = new Actions((WebDriver)AqualityServices.getBrowser().getDriver()).moveToElement((WebElement)this.element.getElement());
        AqualityServices.get(IElementActionRetrier.class).doWithRetry(() -> ((Actions)function.apply(actions)).build().perform());
    }

    private void infoLoc(String key) {
        AqualityServices.getLocalizedLogger().infoElementAction(this.type, this.name, key, new Object[0]);
    }
}

