/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements.actions;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.browser.Browser;
import aquality.selenium.browser.JavaScript;
import aquality.selenium.core.utilities.IElementActionRetrier;
import aquality.selenium.elements.HighlightState;
import aquality.selenium.elements.interfaces.IElement;
import aquality.selenium.elements.interfaces.IShadowRootExpander;
import java.util.ArrayList;
import java.util.Arrays;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.SearchContext;

public class JsActions
implements IShadowRootExpander {
    protected IElement element;
    protected String type;
    protected String name;

    public JsActions(IElement element, String type) {
        this.element = element;
        this.type = type;
        this.name = element.getName();
    }

    @Override
    public SearchContext expandShadowRoot() {
        this.logElementAction("loc.shadowroot.expand.js", new Object[0]);
        return (SearchContext)this.executeScript(JavaScript.EXPAND_SHADOW_ROOT);
    }

    public void setAttribute(String name, String value) {
        this.logElementAction("loc.el.attr.set", name, value);
        this.executeScript(JavaScript.SET_ATTRIBUTE, name, value);
    }

    public void click() {
        this.logElementAction("loc.clicking.js", new Object[0]);
        this.highlightElement();
        this.executeScript(JavaScript.CLICK_ELEMENT);
    }

    public void clickAndWait() {
        this.click();
        this.getBrowser().waitForPageToLoad();
    }

    public void highlightElement() {
        this.highlightElement(HighlightState.DEFAULT);
    }

    public void highlightElement(HighlightState highlightState) {
        if (AqualityServices.getBrowserProfile().isElementHighlightEnabled() && !highlightState.equals((Object)HighlightState.NOT_HIGHLIGHT) || highlightState.equals((Object)HighlightState.HIGHLIGHT)) {
            this.executeScript(JavaScript.BORDER_ELEMENT);
        }
    }

    public void scrollIntoView() {
        this.logElementAction("loc.scrolling.js", new Object[0]);
        this.executeScript(JavaScript.SCROLL_TO_ELEMENT, true);
    }

    public void scrollBy(int x, int y) {
        this.logElementAction("loc.scrolling.js", new Object[0]);
        this.executeScript(JavaScript.SCROLL_BY, x, y);
    }

    public void scrollToTheCenter() {
        this.logElementAction("loc.scrolling.center.js", new Object[0]);
        this.executeScript(JavaScript.SCROLL_TO_ELEMENT_CENTER);
    }

    public void setValue(String value) {
        this.logElementAction("loc.setting.value", value);
        this.executeScript(JavaScript.SET_VALUE, value);
    }

    public void setFocus() {
        this.logElementAction("loc.focusing", new Object[0]);
        this.executeScript(JavaScript.SET_FOCUS);
    }

    public boolean isElementOnScreen() {
        this.logElementAction("loc.is.present.js", new Object[0]);
        boolean value = (Boolean)this.executeScript(JavaScript.ELEMENT_IS_ON_SCREEN);
        this.logElementAction("loc.is.present.value", value);
        return value;
    }

    public String getElementText() {
        this.logElementAction("loc.get.text.js", new Object[0]);
        String value = (String)this.executeScript(JavaScript.GET_ELEMENT_TEXT);
        this.logElementAction("loc.text.value", value);
        return value;
    }

    public void hoverMouse() {
        this.logElementAction("loc.hover.js", new Object[0]);
        this.executeScript(JavaScript.MOUSE_HOVER);
    }

    public Point getViewPortCoordinates() {
        ArrayList coordinates = (ArrayList)this.executeScript(JavaScript.GET_VIEWPORT_COORDINATES);
        return new Point(Math.round(((Number)coordinates.get(0)).floatValue()), Math.round(((Number)coordinates.get(1)).floatValue()));
    }

    public String getXPath() {
        this.logElementAction("loc.get.xpath.js", new Object[0]);
        String value = (String)this.executeScript(JavaScript.GET_ELEMENT_XPATH);
        this.logElementAction("loc.xpath.value", value);
        return value;
    }

    private Object[] resolveArguments(Object ... args) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(this.element.getElement());
        arguments.addAll(Arrays.asList(args));
        return arguments.toArray();
    }

    public Object executeScript(ScriptKey pinnedScript, Object ... args) {
        this.logElementAction("loc.el.execute.pinnedjs", new Object[0]);
        Object result = this.getActionRetrier().doWithRetry(() -> this.getBrowser().executeScript(pinnedScript, this.resolveArguments(args)));
        if (result != null) {
            this.logElementAction("loc.el.execute.pinnedjs.result", result);
        }
        return result;
    }

    protected Object executeScript(JavaScript javaScript) {
        return this.getActionRetrier().doWithRetry(() -> this.getBrowser().executeScript(javaScript, this.element.getElement()));
    }

    protected Object executeScript(JavaScript javaScript, Object ... args) {
        return this.getActionRetrier().doWithRetry(() -> this.getBrowser().executeScript(javaScript, this.resolveArguments(args)));
    }

    protected void logElementAction(String key, Object ... args) {
        AqualityServices.getLocalizedLogger().infoElementAction(this.type, this.name, key, args);
    }

    private Browser getBrowser() {
        return AqualityServices.getBrowser();
    }

    private IElementActionRetrier getActionRetrier() {
        return AqualityServices.get(IElementActionRetrier.class);
    }
}

