/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements;

import aquality.selenium.core.elements.ElementState;
import aquality.selenium.elements.Attributes;
import aquality.selenium.elements.Element;
import aquality.selenium.elements.HighlightState;
import aquality.selenium.elements.interfaces.ITextBox;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class TextBox
extends Element
implements ITextBox {
    private static final String LOG_TYPING = "loc.text.typing";
    private static final String LOG_CLEARING = "loc.text.clearing";
    private final String logMaskedValue = this.getLocalizationManager().getLocalizedMessage("loc.text.masked_value", new Object[0]);

    protected TextBox(By locator, String name, ElementState state) {
        super(locator, name, state);
    }

    protected String getElementType() {
        return this.getLocalizationManager().getLocalizedMessage("loc.text.field", new Object[0]);
    }

    @Override
    public void type(String value) {
        this.type(value, false);
    }

    @Override
    public void typeSecret(String value) {
        this.type(value, true);
    }

    @Override
    public void clearAndType(String value) {
        this.clearAndType(value, false);
    }

    @Override
    public void clearAndTypeSecret(String value) {
        this.clearAndType(value, true);
    }

    @Override
    public void submit() {
        this.doWithRetry(() -> this.getElement().submit());
    }

    @Override
    public String getValue() {
        return this.getAttribute(Attributes.VALUE.toString(), HighlightState.DEFAULT);
    }

    @Override
    public void focus() {
        this.doWithRetry(() -> this.getElement().sendKeys(new CharSequence[]{""}));
    }

    @Override
    public void unfocus() {
        this.doWithRetry(() -> this.getElement().sendKeys(new CharSequence[]{Keys.TAB}));
    }

    private void type(String value, boolean maskValueInLog) {
        this.logElementAction(LOG_TYPING, new Object[]{maskValueInLog ? this.logMaskedValue : value});
        this.getJsActions().highlightElement();
        this.doWithRetry(() -> this.getElement().sendKeys(new CharSequence[]{value}));
    }

    private void clearAndType(String value, boolean maskValueInLog) {
        this.logElementAction(LOG_CLEARING, new Object[0]);
        this.logElementAction(LOG_TYPING, new Object[]{maskValueInLog ? this.logMaskedValue : value});
        this.getJsActions().highlightElement();
        this.doWithRetry(() -> {
            this.getElement().clear();
            this.getElement().sendKeys(new CharSequence[]{value});
        });
    }
}

