/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements;

import aquality.selenium.core.elements.ElementState;
import aquality.selenium.elements.Attributes;
import aquality.selenium.elements.ComboBox;
import aquality.selenium.elements.interfaces.IMultiChoiceBox;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class MultiChoiceBox
extends ComboBox
implements IMultiChoiceBox {
    private static final String LOG_DESELECTING_VALUE = "loc.deselecting.value";

    protected MultiChoiceBox(By locator, String name, ElementState state) {
        super(locator, name, state);
    }

    @Override
    protected String getElementType() {
        return this.getLocalizationManager().getLocalizedMessage("loc.multichoicebox", new Object[0]);
    }

    @Override
    public List<String> getSelectedValues() {
        this.logElementAction("loc.combobox.getting.selected.value", new Object[0]);
        return this.collectSelectedOptions(option -> option.getAttribute(Attributes.VALUE.toString()), "value");
    }

    @Override
    public List<String> getSelectedTexts() {
        this.logElementAction("loc.combobox.getting.selected.text", new Object[0]);
        return this.collectSelectedOptions(WebElement::getText, "text");
    }

    private List<String> collectSelectedOptions(Function<WebElement, String> valueGetter, String valueType) {
        List texts = (List)this.doWithRetry(() -> new Select((WebElement)this.getElement()).getAllSelectedOptions().stream().map(valueGetter).collect(Collectors.toList()));
        String logValue = texts.stream().map(value -> String.format("'%s'", value)).collect(Collectors.joining(", "));
        this.logElementAction(String.format("loc.combobox.selected.%s", valueType), new Object[]{logValue});
        return texts;
    }

    @Override
    public void selectAll() {
        this.logElementAction("loc.multichoicebox.select.all", new Object[0]);
        this.applyFunctionToOptionsThatContain(element -> element.getAttribute(Attributes.VALUE.toString()), Select::selectByValue, "");
    }

    @Override
    public void deselectAll() {
        this.logElementAction("loc.multichoicebox.deselect.all", new Object[0]);
        this.doWithRetry(() -> new Select((WebElement)this.getElement()).deselectAll());
    }

    @Override
    public void deselectByIndex(int index) {
        this.logElementAction(LOG_DESELECTING_VALUE, new Object[]{String.format("#%s", index)});
        this.doWithRetry(() -> new Select((WebElement)this.getElement()).deselectByIndex(index));
    }

    @Override
    public void deselectByValue(String value) {
        this.logElementAction(LOG_DESELECTING_VALUE, new Object[]{value});
        this.doWithRetry(() -> new Select((WebElement)this.getElement()).deselectByValue(value));
    }

    @Override
    public void deselectByContainingValue(String value) {
        this.logElementAction(LOG_DESELECTING_VALUE, new Object[]{value});
        this.applyFunctionToOptionsThatContain(element -> element.getAttribute(Attributes.VALUE.toString()), Select::deselectByValue, value);
    }

    @Override
    public void deselectByText(String text) {
        this.logElementAction("loc.multichoicebox.deselect.by.text", new Object[]{text});
        this.doWithRetry(() -> new Select((WebElement)this.getElement()).deselectByVisibleText(text));
    }

    @Override
    public void deselectByContainingText(String text) {
        this.logElementAction("loc.multichoicebox.deselect.by.text", new Object[]{text});
        this.applyFunctionToOptionsThatContain(WebElement::getText, Select::deselectByVisibleText, text);
    }
}

