/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements;

import aquality.selenium.browser.JavaScript;
import aquality.selenium.core.elements.interfaces.IElement;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import aquality.selenium.core.elements.interfaces.IElementSupplier;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.waitings.IConditionalWait;
import aquality.selenium.elements.Button;
import aquality.selenium.elements.CheckBox;
import aquality.selenium.elements.ComboBox;
import aquality.selenium.elements.Element;
import aquality.selenium.elements.Label;
import aquality.selenium.elements.Link;
import aquality.selenium.elements.MultiChoiceBox;
import aquality.selenium.elements.RadioButton;
import aquality.selenium.elements.TextBox;
import aquality.selenium.elements.interfaces.IButton;
import aquality.selenium.elements.interfaces.ICheckBox;
import aquality.selenium.elements.interfaces.IComboBox;
import aquality.selenium.elements.interfaces.IElementFactory;
import aquality.selenium.elements.interfaces.ILabel;
import aquality.selenium.elements.interfaces.ILink;
import aquality.selenium.elements.interfaces.IMultiChoiceBox;
import aquality.selenium.elements.interfaces.IRadioButton;
import aquality.selenium.elements.interfaces.ITextBox;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ByIdOrName;

public class ElementFactory
extends aquality.selenium.core.elements.ElementFactory
implements IElementFactory {
    private final IConditionalWait conditionalWait;
    private final IElementFinder elementFinder;

    @Inject
    public ElementFactory(IConditionalWait conditionalWait, IElementFinder elementFinder, ILocalizationManager localizationManager) {
        super(conditionalWait, elementFinder, localizationManager);
        this.conditionalWait = conditionalWait;
        this.elementFinder = elementFinder;
    }

    private static Map<Class<? extends By>, String> getLocatorToXPathTemplateMap() {
        HashMap<Class<? extends By>, String> locatorToXPathTemplateMap = new HashMap<Class<? extends By>, String>();
        locatorToXPathTemplateMap.put(By.ByClassName.class, "//*[contains(@class,'%s')]");
        locatorToXPathTemplateMap.put(By.ByName.class, "//*[@name='%s']");
        locatorToXPathTemplateMap.put(By.ById.class, "//*[@id='%s']");
        locatorToXPathTemplateMap.put(ByIdOrName.class, "//*[@id='%1$s' or @name='%1$s']");
        return locatorToXPathTemplateMap;
    }

    protected Map<Class<? extends IElement>, Class<? extends IElement>> getElementTypesMap() {
        HashMap<Class<? extends IElement>, Class<? extends IElement>> typesMap = new HashMap<Class<? extends IElement>, Class<? extends IElement>>();
        typesMap.put(IButton.class, Button.class);
        typesMap.put(ICheckBox.class, CheckBox.class);
        typesMap.put(IComboBox.class, ComboBox.class);
        typesMap.put(IMultiChoiceBox.class, MultiChoiceBox.class);
        typesMap.put(ILabel.class, Label.class);
        typesMap.put(ILink.class, Link.class);
        typesMap.put(IRadioButton.class, RadioButton.class);
        typesMap.put(ITextBox.class, TextBox.class);
        return typesMap;
    }

    protected By generateLocator(By multipleElementsLocator, WebElement webElement, int elementIndex) {
        try {
            return this.generateXpathLocator(multipleElementsLocator, webElement, elementIndex);
        }
        catch (InvalidArgumentException | JavascriptException ex) {
            return By.cssSelector((String)((String)this.conditionalWait.waitFor(driver -> ((RemoteWebDriver)Objects.requireNonNull(driver)).executeScript(JavaScript.GET_ELEMENT_CSS_SELECTOR.getScript(), new Object[]{webElement}), ex.getMessage() + ". CSS selector generation failed too.")));
        }
    }

    protected By generateXpathLocator(By multipleElementsLocator, WebElement webElement, int elementIndex) {
        By locator;
        if (this.isLocatorSupportedForXPathExtraction(multipleElementsLocator) && this.elementFinder.findElements(locator = super.generateXpathLocator(multipleElementsLocator, webElement, elementIndex)).size() == 1) {
            return locator;
        }
        return By.xpath((String)((String)this.conditionalWait.waitFor(driver -> ((RemoteWebDriver)Objects.requireNonNull(driver)).executeScript(JavaScript.GET_ELEMENT_XPATH.getScript(), new Object[]{webElement}), "XPath generation failed")));
    }

    protected boolean isLocatorSupportedForXPathExtraction(By locator) {
        return ElementFactory.getLocatorToXPathTemplateMap().containsKey(locator.getClass()) || super.isLocatorSupportedForXPathExtraction(locator);
    }

    protected String extractXPathFromLocator(By locator) {
        String locatorString = locator.toString();
        int indexOfDots = locatorString.indexOf(58);
        String locValuableString = indexOfDots == -1 ? locatorString.substring(locatorString.indexOf(34)).replace("\"", "") : locatorString.substring(indexOfDots + 1).trim();
        Class<?> locatorClass = locator.getClass();
        return ElementFactory.getLocatorToXPathTemplateMap().containsKey(locator.getClass()) ? String.format(ElementFactory.getLocatorToXPathTemplateMap().get(locatorClass), locValuableString) : super.extractXPathFromLocator(locator);
    }

    protected <T extends IElement> IElementSupplier<T> getDefaultElementSupplier(Class<T> clazz) {
        IElementSupplier baseSupplier = super.getDefaultElementSupplier(clazz);
        return (locator, name, state) -> {
            IElement element = baseSupplier.get(locator, name, state);
            if (element instanceof Element) {
                ((Element)element).setElementFinder(this.elementFinder);
            }
            return element;
        };
    }
}

