/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.browser.Browser;
import aquality.selenium.browser.JavaScript;
import aquality.selenium.core.configurations.IElementCacheConfiguration;
import aquality.selenium.core.configurations.ITimeoutConfiguration;
import aquality.selenium.core.elements.CachedElementStateProvider;
import aquality.selenium.core.elements.ElementState;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import aquality.selenium.core.elements.interfaces.IElementStateProvider;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.utilities.IElementActionRetrier;
import aquality.selenium.core.visualization.IImageComparator;
import aquality.selenium.core.waitings.IConditionalWait;
import aquality.selenium.elements.ElementStateProvider;
import aquality.selenium.elements.ElementType;
import aquality.selenium.elements.HighlightState;
import aquality.selenium.elements.actions.JsActions;
import aquality.selenium.elements.actions.MouseActions;
import aquality.selenium.elements.interfaces.IElement;
import aquality.selenium.elements.interfaces.IElementFactory;
import java.time.Duration;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.remote.RemoteWebElement;

public abstract class Element
extends aquality.selenium.core.elements.Element
implements IElement {
    private IElementFinder elementFinder;

    protected Element(By loc, String nameOf, ElementState stateOf) {
        super(loc, nameOf, stateOf);
    }

    protected Browser getApplication() {
        return AqualityServices.getBrowser();
    }

    protected IElementFactory getElementFactory() {
        return AqualityServices.getElementFactory();
    }

    protected IElementFinder getElementFinder() {
        if (this.elementFinder == null) {
            this.elementFinder = AqualityServices.get(IElementFinder.class);
        }
        return this.elementFinder;
    }

    void setElementFinder(IElementFinder elementFinder) {
        this.elementFinder = elementFinder;
    }

    protected IImageComparator getImageComparator() {
        return AqualityServices.get(IImageComparator.class);
    }

    protected IElementCacheConfiguration getElementCacheConfiguration() {
        return AqualityServices.get(IElementCacheConfiguration.class);
    }

    protected IElementActionRetrier getElementActionRetrier() {
        return AqualityServices.get(IElementActionRetrier.class);
    }

    protected ILocalizedLogger getLocalizedLogger() {
        return AqualityServices.getLocalizedLogger();
    }

    protected ILocalizationManager getLocalizationManager() {
        return AqualityServices.get(ILocalizationManager.class);
    }

    protected IConditionalWait getConditionalWait() {
        return AqualityServices.getConditionalWait();
    }

    public RemoteWebElement getElement(Duration timeout) {
        try {
            return super.getElement(timeout);
        }
        catch (NoSuchElementException e) {
            this.getLogger().error(e.getMessage());
            long timeoutInSeconds = timeout == null ? AqualityServices.get(ITimeoutConfiguration.class).getCondition().getSeconds() : timeout.getSeconds();
            throw new NoSuchElementException(String.format("element %s was not found in %d seconds in state %s by locator %s", this.getName(), timeoutInSeconds, this.getElementState(), this.getLocator()));
        }
    }

    public void click() {
        this.logElementAction("loc.clicking", new Object[0]);
        this.getJsActions().highlightElement();
        this.doWithRetry(() -> this.getElement().click());
    }

    @Override
    public void clickAndWait() {
        this.click();
        this.getBrowser().waitForPageToLoad();
    }

    @Override
    public String getText() {
        return this.getText(HighlightState.DEFAULT);
    }

    @Override
    public String getText(HighlightState highlightState) {
        this.logElementAction("loc.get.text", new Object[0]);
        this.getJsActions().highlightElement(highlightState);
        String value = (String)this.doWithRetry(() -> this.getElement().getText());
        this.logElementAction("loc.text.value", new Object[]{value});
        return value;
    }

    public IElementStateProvider state() {
        return this.getElementCacheConfiguration().isEnabled() ? new CachedElementStateProvider(this.getLocator(), this.getConditionalWait(), this.getCache(), this.logElementState()) : new ElementStateProvider(this.getLocator(), this.getConditionalWait(), this.getElementFinder(), this.logElementState());
    }

    @Override
    public String getAttribute(String attr, HighlightState highlightState) {
        this.logElementAction("loc.el.getattr", new Object[]{attr});
        this.getJsActions().highlightElement(highlightState);
        String value = (String)this.doWithRetry(() -> this.getElement().getAttribute(attr));
        this.logElementAction("loc.el.attr.value", new Object[]{attr, value});
        return value;
    }

    @Override
    public String getCssValue(String propertyName, HighlightState highlightState) {
        this.logElementAction("loc.el.cssvalue", new Object[]{propertyName});
        this.getJsActions().highlightElement(highlightState);
        String value = (String)this.doWithRetry(() -> this.getElement().getCssValue(propertyName));
        this.logElementAction("loc.el.attr.value", new Object[]{propertyName, value});
        return value;
    }

    @Override
    public void setInnerHtml(String value) {
        this.click();
        this.logElementAction("loc.send.text", new Object[]{value});
        this.getBrowser().executeScript(JavaScript.SET_INNER_HTML, this.getElement(), value);
    }

    private Browser getBrowser() {
        return AqualityServices.getBrowser();
    }

    @Override
    public JsActions getJsActions() {
        return new JsActions(this, this.getElementType());
    }

    @Override
    public MouseActions getMouseActions() {
        return new MouseActions(this, this.getElementType());
    }

    @Override
    public <T extends IElement> T findChildElement(By childLoc, String name, ElementType elementType, ElementState state) {
        return this.getElementFactory().findChildElement(this, childLoc, name, elementType, state);
    }

    @Override
    public void sendKeys(Keys key) {
        this.logElementAction("loc.text.sending.key", new Object[]{Keys.class.getSimpleName().concat(".").concat(key.name())});
        this.doWithRetry(() -> this.getElement().sendKeys(new CharSequence[]{key}));
    }

    @Override
    public SearchContext expandShadowRoot() {
        this.logElementAction("loc.shadowroot.expand", new Object[0]);
        return this.getElement().getShadowRoot();
    }
}

