/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.elements;

import aquality.selenium.core.elements.ElementState;
import aquality.selenium.elements.Attributes;
import aquality.selenium.elements.Element;
import aquality.selenium.elements.actions.ComboBoxJsActions;
import aquality.selenium.elements.interfaces.IComboBox;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class ComboBox
extends Element
implements IComboBox {
    private static final String LOG_SELECTING_VALUE = "loc.selecting.value";

    protected ComboBox(By locator, String name, ElementState state) {
        super(locator, name, state);
    }

    protected String getElementType() {
        return this.getLocalizationManager().getLocalizedMessage("loc.combobox", new Object[0]);
    }

    @Override
    public void selectByIndex(int index) {
        this.logElementAction(LOG_SELECTING_VALUE, new Object[]{String.format("#%s", index)});
        this.doWithRetry(() -> new Select((WebElement)this.getElement()).selectByIndex(index));
    }

    @Override
    public void selectByText(String value) {
        this.logElementAction("loc.combobox.select.by.text", new Object[]{value});
        this.doWithRetry(() -> new Select((WebElement)this.getElement()).selectByVisibleText(value));
    }

    @Override
    public void clickAndSelectByText(String value) {
        this.click();
        this.selectByText(value);
    }

    @Override
    public void selectByContainingText(String text) {
        this.logElementAction("loc.combobox.select.by.text", new Object[]{text});
        this.applyFunctionToOptionsThatContain(WebElement::getText, Select::selectByVisibleText, text);
    }

    @Override
    public void selectByContainingValue(String value) {
        this.logElementAction(LOG_SELECTING_VALUE, new Object[]{value});
        this.applyFunctionToOptionsThatContain(element -> element.getAttribute(Attributes.VALUE.toString()), Select::selectByValue, value);
    }

    protected void applyFunctionToOptionsThatContain(Function<WebElement, String> getValueFunc, BiConsumer<Select, String> selectFunc, String value) {
        this.doWithRetry(() -> {
            Select select = new Select((WebElement)this.getElement());
            List elements = select.getOptions();
            boolean isSelected = false;
            for (WebElement el : elements) {
                String currentValue = (String)getValueFunc.apply(el);
                this.getLogger().debug(currentValue);
                if (!currentValue.toLowerCase().contains(value.toLowerCase())) continue;
                selectFunc.accept(select, currentValue);
                isSelected = true;
            }
            if (!isSelected) {
                throw new InvalidElementStateException(String.format(this.getLocalizationManager().getLocalizedMessage("loc.combobox.impossible.to.find.option.contain.value.or.text", new Object[0]), value, this.getName()));
            }
        });
    }

    @Override
    public void selectByValue(String value) {
        this.logElementAction(LOG_SELECTING_VALUE, new Object[]{value});
        this.doWithRetry(() -> new Select((WebElement)this.getElement()).selectByValue(value));
    }

    @Override
    public void clickAndSelectByValue(String value) {
        this.click();
        this.selectByValue(value);
    }

    @Override
    public String getSelectedValue() {
        this.logElementAction("loc.combobox.getting.selected.value", new Object[0]);
        String value = (String)this.doWithRetry(() -> new Select((WebElement)this.getElement()).getFirstSelectedOption().getAttribute(Attributes.VALUE.toString()));
        this.logElementAction("loc.combobox.selected.value", new Object[]{value});
        return value;
    }

    @Override
    public String getSelectedText() {
        this.logElementAction("loc.combobox.getting.selected.text", new Object[0]);
        String text = (String)this.doWithRetry(() -> new Select((WebElement)this.getElement()).getFirstSelectedOption().getText());
        this.logElementAction("loc.combobox.selected.text", new Object[]{text});
        return text;
    }

    @Override
    public List<String> getValues() {
        this.logElementAction("loc.combobox.get.values", new Object[0]);
        List values = (List)this.doWithRetry(() -> new Select((WebElement)this.getElement()).getOptions().stream().map(option -> option.getAttribute(Attributes.VALUE.toString())).collect(Collectors.toList()));
        this.logElementAction("loc.combobox.values", new Object[]{values.stream().map(value -> String.format("'%s'", value)).collect(Collectors.joining(", "))});
        return values;
    }

    @Override
    public List<String> getTexts() {
        this.logElementAction("loc.combobox.get.texts", new Object[0]);
        List values = (List)this.doWithRetry(() -> new Select((WebElement)this.getElement()).getOptions().stream().map(WebElement::getText).collect(Collectors.toList()));
        this.logElementAction("loc.combobox.texts", new Object[]{values.stream().map(value -> String.format("'%s'", value)).collect(Collectors.joining(", "))});
        return values;
    }

    @Override
    public ComboBoxJsActions getJsActions() {
        return new ComboBoxJsActions(this, this.getElementType());
    }
}

