/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.configuration.driversettings;

import aquality.selenium.browser.BrowserName;
import aquality.selenium.configuration.driversettings.DriverSettings;
import aquality.selenium.core.utilities.ISettingsFile;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class FirefoxSettings
extends DriverSettings {
    public FirefoxSettings(ISettingsFile settingsFile) {
        super(settingsFile);
    }

    @Override
    public AbstractDriverOptions<?> getDriverOptions() {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        this.setCapabilities((MutableCapabilities)firefoxOptions);
        this.setFirefoxPrefs(firefoxOptions);
        this.setFirefoxArgs(firefoxOptions);
        firefoxOptions.setPageLoadStrategy(this.getPageLoadStrategy());
        return firefoxOptions;
    }

    @Override
    public String getDownloadDirCapabilityKey() {
        return "browser.download.dir";
    }

    @Override
    public BrowserName getBrowserName() {
        return BrowserName.FIREFOX;
    }

    private void setFirefoxPrefs(FirefoxOptions options) {
        Map<String, Object> configOptions = this.getBrowserOptions();
        configOptions.forEach((key, value) -> {
            if (key.equals(this.getDownloadDirCapabilityKey())) {
                options.addPreference(key, (Object)this.getDownloadDir());
            } else if (value instanceof Boolean) {
                options.addPreference(key, (Object)((Boolean)value));
            } else if (value instanceof Integer) {
                options.addPreference(key, (Object)((Integer)value));
            } else if (value instanceof String) {
                options.addPreference(key, (Object)((String)value));
            }
        });
    }

    private void setFirefoxArgs(FirefoxOptions options) {
        for (String arg : this.getBrowserStartArguments()) {
            options.addArguments(new String[]{arg});
        }
    }
}

