/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.configuration.driversettings;

import aquality.selenium.browser.BrowserName;
import aquality.selenium.configuration.driversettings.DriverSettings;
import aquality.selenium.core.utilities.ISettingsFile;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class EdgeSettings
extends DriverSettings {
    public EdgeSettings(ISettingsFile settingsFile) {
        super(settingsFile);
    }

    @Override
    public AbstractDriverOptions<?> getDriverOptions() {
        EdgeOptions edgeOptions = new EdgeOptions();
        this.setCapabilities((MutableCapabilities)edgeOptions);
        this.setPrefs(edgeOptions);
        this.getBrowserStartArguments().forEach(xva$0 -> edgeOptions.addArguments(new String[]{xva$0}));
        edgeOptions.setPageLoadStrategy(this.getPageLoadStrategy());
        this.setLoggingPreferences((MutableCapabilities)edgeOptions, "ms:loggingPrefs");
        return edgeOptions;
    }

    @Override
    public String getDownloadDirCapabilityKey() {
        return "download.default_directory";
    }

    private void setPrefs(EdgeOptions options) {
        HashMap prefs = new HashMap();
        Map<String, Object> configOptions = this.getBrowserOptions();
        configOptions.forEach((key, value) -> {
            if (key.equals(this.getDownloadDirCapabilityKey())) {
                prefs.put(key, this.getDownloadDir());
            } else {
                prefs.put(key, value);
            }
        });
        options.setExperimentalOption("prefs", prefs);
    }

    @Override
    public BrowserName getBrowserName() {
        return BrowserName.EDGE;
    }
}

