/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.configuration.driversettings;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.configuration.driversettings.IDriverSettings;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.logging.Logger;
import aquality.selenium.core.utilities.ISettingsFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.logging.LoggingPreferences;

abstract class DriverSettings
implements IDriverSettings {
    private final ISettingsFile settingsFile;
    private Map<String, Object> options;
    private Map<String, Object> capabilities;
    private Map<String, Level> loggingPreferences;
    private List<String> startArguments;

    protected DriverSettings(ISettingsFile settingsFile) {
        this.settingsFile = settingsFile;
    }

    protected ISettingsFile getSettingsFile() {
        return this.settingsFile;
    }

    protected Map<String, Object> getBrowserOptions() {
        if (this.options == null) {
            this.options = this.getMapOrEmpty(CapabilityType.OPTIONS);
        }
        return this.options;
    }

    protected Map<String, Object> getBrowserCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.getMapOrEmpty(CapabilityType.CAPABILITIES);
        }
        return this.capabilities;
    }

    protected Map<String, Level> getLoggingPreferences() {
        if (this.loggingPreferences == null) {
            this.loggingPreferences = this.getMapOrEmpty(CapabilityType.LOGGING_PREFERENCES).entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), pair -> Level.parse(pair.getValue().toString().toUpperCase())));
        }
        return this.loggingPreferences;
    }

    private Map<String, Object> getMapOrEmpty(CapabilityType capabilityType) {
        String path = this.getDriverSettingsPath(capabilityType);
        Map map = this.getSettingsFile().isValuePresent(path) ? this.getSettingsFile().getMap(path) : Collections.emptyMap();
        this.logCollection("loc.browser.".concat(capabilityType.getKey()), map);
        return map;
    }

    protected List<String> getBrowserStartArguments() {
        if (this.startArguments == null) {
            boolean isValuePresent;
            String path = this.getDriverSettingsPath(CapabilityType.START_ARGS);
            try {
                this.getSettingsFile().getValue(path);
                isValuePresent = true;
            }
            catch (IllegalArgumentException e) {
                isValuePresent = false;
            }
            this.startArguments = isValuePresent ? this.getSettingsFile().getList(path) : Collections.emptyList();
            this.logCollection("loc.browser.arguments", this.startArguments);
        }
        return this.startArguments;
    }

    protected String getBinaryLocation(String defaultBinaryLocation) {
        String value = (String)this.getSettingsFile().getValueOrDefault(this.getDriverSettingsPath("binaryLocation"), (Object)defaultBinaryLocation);
        int varStartIndex = value.indexOf(37);
        int varEndIndex = value.lastIndexOf(37);
        return varStartIndex == 0 && varStartIndex != varEndIndex ? System.getenv(value.substring(varStartIndex + 1, varEndIndex)) + value.substring(varEndIndex + 1) : this.getAbsolutePath(value);
    }

    @SafeVarargs
    private final <T> void logCollection(String messageKey, T ... elements) {
        if (elements.length == 1 && (elements[0] instanceof Map && !((Map)elements[0]).isEmpty() || elements[0] instanceof List && !((List)elements[0]).isEmpty())) {
            AqualityServices.getLocalizedLogger().debug(messageKey, new Object[]{System.lineSeparator() + StringUtils.join((Object[])elements)});
        }
    }

    @Override
    public PageLoadStrategy getPageLoadStrategy() {
        String value = (String)this.getSettingsFile().getValueOrDefault(this.getDriverSettingsPath("pageLoadStrategy"), (Object)"normal");
        return PageLoadStrategy.fromString((String)value.toLowerCase());
    }

    private String getDriverSettingsPath(CapabilityType capabilityType) {
        return this.getDriverSettingsPath(capabilityType.getKey());
    }

    String getDriverSettingsPath(String ... paths) {
        String pathToDriverSettings = String.format("/driverSettings/%1$s", this.getBrowserName().toString().toLowerCase());
        return pathToDriverSettings.concat(Arrays.stream(paths).map("/"::concat).collect(Collectors.joining()));
    }

    void setCapabilities(MutableCapabilities options) {
        this.getBrowserCapabilities().forEach((arg_0, arg_1) -> ((MutableCapabilities)options).setCapability(arg_0, arg_1));
    }

    void setLoggingPreferences(MutableCapabilities options, String capabilityKey) {
        if (!this.getLoggingPreferences().isEmpty()) {
            LoggingPreferences logs = new LoggingPreferences();
            this.getLoggingPreferences().forEach((arg_0, arg_1) -> ((LoggingPreferences)logs).enable(arg_0, arg_1));
            options.setCapability(capabilityKey, (Object)logs);
        }
    }

    @Override
    public String getDownloadDir() {
        String key;
        Map<String, Object> browserOptions = this.getBrowserOptions();
        if (browserOptions.containsKey(key = this.getDownloadDirCapabilityKey())) {
            String pathInConfiguration = String.valueOf(browserOptions.get(key));
            return pathInConfiguration.contains(".") ? this.getAbsolutePath(pathInConfiguration) : pathInConfiguration;
        }
        throw new IllegalArgumentException(String.format("failed to find %s profiles option for %s", new Object[]{key, this.getBrowserName()}));
    }

    protected String getAbsolutePath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            String message = String.format(AqualityServices.get(ILocalizationManager.class).getLocalizedMessage("loc.file.reading_exception", new Object[0]), path);
            this.getLogger().fatal(message, (Throwable)e);
            throw new IllegalArgumentException(message);
        }
    }

    private Logger getLogger() {
        return Logger.getInstance();
    }

    private static enum CapabilityType {
        CAPABILITIES("capabilities"),
        OPTIONS("options"),
        START_ARGS("startArguments"),
        LOGGING_PREFERENCES("loggingPreferences");

        private final String key;

        private CapabilityType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

