/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.configuration.driversettings;

import aquality.selenium.browser.BrowserName;
import aquality.selenium.configuration.driversettings.DriverSettings;
import aquality.selenium.core.utilities.ISettingsFile;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class ChromeSettings
extends DriverSettings {
    public ChromeSettings(ISettingsFile settingsFile) {
        super(settingsFile);
    }

    @Override
    public AbstractDriverOptions<?> getDriverOptions() {
        ChromeOptions chromeOptions = new ChromeOptions();
        this.setChromePrefs(chromeOptions);
        this.setCapabilities((MutableCapabilities)chromeOptions);
        this.setChromeArgs(chromeOptions);
        chromeOptions.setPageLoadStrategy(this.getPageLoadStrategy());
        this.setLoggingPreferences((MutableCapabilities)chromeOptions, "goog:loggingPrefs");
        return chromeOptions;
    }

    private void setChromePrefs(ChromeOptions options) {
        HashMap chromePrefs = new HashMap();
        Map<String, Object> configOptions = this.getBrowserOptions();
        configOptions.forEach((key, value) -> {
            if (key.equals(this.getDownloadDirCapabilityKey())) {
                chromePrefs.put(key, this.getDownloadDir());
            } else {
                chromePrefs.put(key, value);
            }
        });
        options.setExperimentalOption("prefs", chromePrefs);
    }

    private void setChromeArgs(ChromeOptions options) {
        for (String arg : this.getBrowserStartArguments()) {
            options.addArguments(new String[]{arg});
        }
        String allowOriginsArgument = "--remote-allow-origins=*";
        if (!this.getBrowserStartArguments().contains("--remote-allow-origins=*")) {
            options.addArguments(new String[]{"--remote-allow-origins=*"});
        }
    }

    @Override
    public String getDownloadDirCapabilityKey() {
        return "download.default_directory";
    }

    @Override
    public BrowserName getBrowserName() {
        return BrowserName.CHROME;
    }
}

