/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.configuration;

import aquality.selenium.configuration.ITimeoutConfiguration;
import aquality.selenium.core.utilities.ISettingsFile;
import com.google.inject.Inject;
import java.time.Duration;

public class TimeoutConfiguration
extends aquality.selenium.core.configurations.TimeoutConfiguration
implements ITimeoutConfiguration {
    private final ISettingsFile settingsFile;
    private final Duration script;
    private final Duration pageLoad;

    @Inject
    public TimeoutConfiguration(ISettingsFile settingsFile) {
        super(settingsFile);
        this.settingsFile = settingsFile;
        this.script = this.getDurationFromSeconds(TIMEOUT.SCRIPT);
        this.pageLoad = this.getDurationFromSeconds(TIMEOUT.PAGE_LOAD);
    }

    private Duration getDurationFromSeconds(TIMEOUT timeout) {
        long seconds = Long.parseLong(this.settingsFile.getValue("/timeouts/" + timeout.getKey()).toString());
        return Duration.ofSeconds(seconds);
    }

    @Override
    public Duration getScript() {
        return this.script;
    }

    @Override
    public Duration getPageLoad() {
        return this.pageLoad;
    }

    private static enum TIMEOUT {
        SCRIPT("timeoutScript"),
        PAGE_LOAD("timeoutPageLoad");

        private final String key;

        private TIMEOUT(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }
}

