/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.configuration;

import aquality.selenium.browser.BrowserName;
import aquality.selenium.configuration.IBrowserProfile;
import aquality.selenium.configuration.driversettings.ChromeSettings;
import aquality.selenium.configuration.driversettings.DriverSettings;
import aquality.selenium.configuration.driversettings.EdgeSettings;
import aquality.selenium.configuration.driversettings.FirefoxSettings;
import aquality.selenium.configuration.driversettings.IDriverSettings;
import aquality.selenium.configuration.driversettings.IExplorerSettings;
import aquality.selenium.configuration.driversettings.OperaSettings;
import aquality.selenium.configuration.driversettings.SafariSettings;
import aquality.selenium.configuration.driversettings.YandexSettings;
import aquality.selenium.core.utilities.ISettingsFile;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.InvalidArgumentException;

public class BrowserProfile
implements IBrowserProfile {
    private final ISettingsFile settingsFile;

    @Inject
    public BrowserProfile(ISettingsFile settingsFile) {
        this.settingsFile = settingsFile;
    }

    @Override
    public BrowserName getBrowserName() {
        return BrowserName.valueOf(String.valueOf(this.settingsFile.getValue("/browserName")).toUpperCase());
    }

    @Override
    public boolean isRemote() {
        return (Boolean)this.settingsFile.getValue("/isRemote");
    }

    @Override
    public boolean isElementHighlightEnabled() {
        return (Boolean)this.settingsFile.getValue("/isElementHighlightEnabled");
    }

    @Override
    public IDriverSettings getDriverSettings() {
        DriverSettings driverSettings;
        switch (this.getBrowserName()) {
            case CHROME: {
                driverSettings = new ChromeSettings(this.settingsFile);
                break;
            }
            case FIREFOX: {
                driverSettings = new FirefoxSettings(this.settingsFile);
                break;
            }
            case EDGE: {
                driverSettings = new EdgeSettings(this.settingsFile);
                break;
            }
            case IEXPLORER: {
                driverSettings = new IExplorerSettings(this.settingsFile);
                break;
            }
            case SAFARI: {
                driverSettings = new SafariSettings(this.settingsFile);
                break;
            }
            case OPERA: {
                driverSettings = new OperaSettings(this.settingsFile);
                break;
            }
            case YANDEX: {
                driverSettings = new YandexSettings(this.settingsFile);
                break;
            }
            default: {
                throw new UnsupportedOperationException("There are no assigned behaviour for retrieving driver driversettings for browser " + (Object)((Object)this.getBrowserName()));
            }
        }
        return driverSettings;
    }

    @Override
    public URL getRemoteConnectionUrl() {
        String key = "remoteConnectionUrl";
        try {
            return new URL(String.valueOf(this.settingsFile.getValue("/" + key)));
        }
        catch (MalformedURLException e) {
            throw new InvalidArgumentException(String.format("Parameter %1$s was not correct in settings", key));
        }
    }
}

