/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser.devtools;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.browser.devtools.DevToolsHandling;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.logging.HttpExchangeLoggingOptions;
import aquality.selenium.logging.LocalizedLoggerUtility;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.NetworkInterceptor;
import org.openqa.selenium.devtools.idealized.Network;
import org.openqa.selenium.devtools.v85.network.Network;
import org.openqa.selenium.devtools.v85.network.model.ConnectionType;
import org.openqa.selenium.devtools.v85.network.model.Headers;
import org.openqa.selenium.devtools.v85.network.model.Request;
import org.openqa.selenium.devtools.v85.network.model.RequestId;
import org.openqa.selenium.devtools.v85.network.model.RequestWillBeSent;
import org.openqa.selenium.devtools.v85.network.model.Response;
import org.openqa.selenium.devtools.v85.network.model.ResponseReceived;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

public class NetworkHandling {
    public static final String LOC_NETWORK_INTERCEPTOR_START = "loc.browser.network.interceptor.start";
    private final DevToolsHandling tools;
    private final Network<?, ?> network;
    private final ILocalizedLogger logger = AqualityServices.getLocalizedLogger();

    public NetworkHandling(DevToolsHandling tools) {
        this.tools = tools;
        this.network = tools.getDevToolsSession().getDomains().network();
    }

    public void startMonitoring() {
        this.logger.info("loc.browser.network.monitoring.start", new Object[0]);
        this.network.prepareToInterceptTraffic();
    }

    public void stopMonitoring() {
        this.logger.info("loc.browser.network.monitoring.stop", new Object[0]);
        this.network.disable();
    }

    public void setUserAgent(String userAgent) {
        this.logger.info("loc.browser.network.useragent.set", new Object[]{userAgent});
        this.network.setUserAgent(userAgent);
    }

    public void setUserAgent(Network.UserAgent userAgent) {
        this.logger.info("loc.browser.network.useragent.set", new Object[]{userAgent});
        this.network.setUserAgent(userAgent);
    }

    public void addAuthHandler(Predicate<URI> whenThisMatches, Supplier<Credentials> useTheseCredentials) {
        this.logger.info("loc.browser.network.authentication.add", new Object[0]);
        this.network.addAuthHandler(whenThisMatches, useTheseCredentials);
    }

    public void addBasicAuthentication(String hostPart, String username, String password) {
        Predicate<URI> uriPredicate = uri -> uri.getHost().contains(hostPart);
        this.addAuthHandler(uriPredicate, UsernameAndPassword.of((String)username, (String)password));
    }

    public void clearBasicAuthentication() {
        this.logger.info("loc.browser.network.authentication.clear", new Object[0]);
        this.stopMonitoring();
    }

    public void resetNetworkFilter() {
        this.logger.info("loc.browser.network.filter.clear", new Object[0]);
        this.network.resetNetworkFilter();
    }

    public void interceptTrafficWith(Filter filter) {
        this.logger.info("loc.browser.network.filter.set", new Object[0]);
        this.network.interceptTrafficWith(filter);
    }

    public void addRequestListener(Consumer<RequestWillBeSent> listener) {
        this.logger.info("loc.browser.network.event.requestsent.add", new Object[0]);
        this.tools.sendCommand(org.openqa.selenium.devtools.v85.network.Network.enable(Optional.empty(), Optional.empty(), Optional.empty()));
        this.tools.addListener(org.openqa.selenium.devtools.v85.network.Network.requestWillBeSent(), listener);
    }

    public void addResponseListener(Consumer<ResponseReceived> listener) {
        this.logger.info("loc.browser.network.event.responsereceived.add", new Object[0]);
        this.tools.sendCommand(org.openqa.selenium.devtools.v85.network.Network.enable(Optional.empty(), Optional.empty(), Optional.empty()));
        this.tools.addListener(org.openqa.selenium.devtools.v85.network.Network.responseReceived(), listener);
    }

    public void clearListeners() {
        this.tools.clearListeners();
    }

    public void enableHttpExchangeLogging() {
        this.enableHttpExchangeLogging(new HttpExchangeLoggingOptions());
    }

    private String formatHeaders(Headers headers) {
        ArrayList formattedHeaders = new ArrayList();
        headers.forEach((key, value) -> formattedHeaders.add(String.format("%s\t%s: %s", System.lineSeparator(), key, value)));
        return String.join((CharSequence)",", formattedHeaders);
    }

    private Consumer<RequestWillBeSent> getRequestLogger(HttpExchangeLoggingOptions loggingOptions) {
        return requestWillBeSent -> {
            Request request = requestWillBeSent.getRequest();
            if (loggingOptions.getRequestInfo().isEnabled()) {
                LocalizedLoggerUtility.logByLevel(loggingOptions.getRequestInfo().getLogLevel(), "loc.browser.network.event.requestsent.log.info", request.getMethod(), request.getUrl() + request.getUrlFragment().orElse(""), requestWillBeSent.getRequestId());
            }
            if (loggingOptions.getRequestHeaders().isEnabled() && !request.getHeaders().isEmpty()) {
                LocalizedLoggerUtility.logByLevel(loggingOptions.getRequestHeaders().getLogLevel(), "loc.browser.network.event.requestsent.log.headers", this.formatHeaders(request.getHeaders()));
            }
            if (loggingOptions.getRequestPostData().isEnabled() && request.getHasPostData().orElse(false).booleanValue()) {
                LocalizedLoggerUtility.logByLevel(loggingOptions.getRequestPostData().getLogLevel(), "loc.browser.network.event.requestsent.log.data", request.getPostData().orElse(null));
            }
        };
    }

    private Consumer<ResponseReceived> getResponseLogger(HttpExchangeLoggingOptions loggingOptions) {
        return responseReceived -> {
            String responseBody;
            Response response = responseReceived.getResponse();
            RequestId requestId = responseReceived.getRequestId();
            if (loggingOptions.getResponseInfo().isEnabled()) {
                LocalizedLoggerUtility.logByLevel(loggingOptions.getResponseInfo().getLogLevel(), "loc.browser.network.event.responsereceived.log.info", response.getStatus(), response.getUrl(), responseReceived.getType().toString(), requestId);
            }
            if (loggingOptions.getResponseHeaders().isEnabled() && !response.getHeaders().isEmpty()) {
                LocalizedLoggerUtility.logByLevel(loggingOptions.getResponseHeaders().getLogLevel(), "loc.browser.network.event.responsereceived.log.headers", this.formatHeaders(response.getHeaders()));
            }
            if (loggingOptions.getResponseBody().isEnabled() && StringUtils.isNotEmpty((CharSequence)(responseBody = ((Network.GetResponseBodyResponse)this.tools.sendCommand(org.openqa.selenium.devtools.v85.network.Network.getResponseBody((RequestId)requestId))).getBody()))) {
                LocalizedLoggerUtility.logByLevel(loggingOptions.getResponseBody().getLogLevel(), "loc.browser.network.event.responsereceived.log.body", responseBody);
            }
        };
    }

    public void enableHttpExchangeLogging(HttpExchangeLoggingOptions loggingOptions) {
        this.addRequestListener(this.getRequestLogger(loggingOptions));
        this.addResponseListener(this.getResponseLogger(loggingOptions));
    }

    public NetworkInterceptor startNetworkInterceptor(HttpHandler httpHandler) {
        this.logger.info(LOC_NETWORK_INTERCEPTOR_START, new Object[0]);
        return new NetworkInterceptor((WebDriver)AqualityServices.getBrowser().getDriver(), httpHandler);
    }

    public NetworkInterceptor startNetworkInterceptor(Filter filter) {
        this.logger.info(LOC_NETWORK_INTERCEPTOR_START, new Object[0]);
        return new NetworkInterceptor((WebDriver)AqualityServices.getBrowser().getDriver(), filter);
    }

    public NetworkInterceptor startNetworkInterceptor(Routable routable) {
        this.logger.info(LOC_NETWORK_INTERCEPTOR_START, new Object[0]);
        return new NetworkInterceptor((WebDriver)AqualityServices.getBrowser().getDriver(), routable);
    }

    public NetworkInterceptor startNetworkInterceptor(Predicate<HttpRequest> requestMatcher, Supplier<HttpHandler> handler) {
        return this.startNetworkInterceptor((Routable)Route.matching(requestMatcher).to(handler));
    }

    public NetworkInterceptor interceptAllRequests(HttpResponse response) {
        return this.startNetworkInterceptor(req -> true, () -> req -> response);
    }

    public NetworkInterceptor addRequestTransformer(Predicate<HttpRequest> requestMatcher, Function<HttpRequest, HttpRequest> requestTransformer) {
        return this.startNetworkInterceptor(next -> req -> requestMatcher.test(req) ? next.execute((HttpRequest)requestTransformer.apply(req)) : next.execute(req));
    }

    public NetworkInterceptor addRequestHandler(Predicate<HttpRequest> requestMatcher, Function<HttpRequest, HttpResponse> requestHandler) {
        return this.startNetworkInterceptor((Routable)Route.matching(requestMatcher).to(() -> requestHandler::apply));
    }

    public NetworkInterceptor addResponseHandler(Predicate<HttpResponse> responseMatcher, Function<HttpResponse, HttpResponse> responseTransformer) {
        return this.startNetworkInterceptor(next -> req -> {
            HttpResponse response = next.execute(req);
            return responseMatcher.test(response) ? (HttpResponse)responseTransformer.apply(response) : response;
        });
    }

    public void clearNetworkInterceptor() {
        this.resetNetworkFilter();
    }

    public void emulateConditions(Boolean offline, Number latency, Number downloadThroughput, Number uploadThroughput) {
        this.tools.sendCommand(org.openqa.selenium.devtools.v85.network.Network.enable(Optional.empty(), Optional.empty(), Optional.empty()));
        this.tools.sendCommand(org.openqa.selenium.devtools.v85.network.Network.emulateNetworkConditions((Boolean)offline, (Number)latency, (Number)downloadThroughput, (Number)uploadThroughput, Optional.empty()));
    }

    public void emulateConditions(Boolean offline, Number latency, Number downloadThroughput, Number uploadThroughput, String connectionType) {
        this.tools.sendCommand(org.openqa.selenium.devtools.v85.network.Network.enable(Optional.empty(), Optional.empty(), Optional.empty()));
        this.tools.sendCommand(org.openqa.selenium.devtools.v85.network.Network.emulateNetworkConditions((Boolean)offline, (Number)latency, (Number)downloadThroughput, (Number)uploadThroughput, Optional.of(ConnectionType.fromString((String)connectionType))));
    }
}

