/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser.devtools;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.browser.devtools.DevToolsHandling;
import aquality.selenium.browser.devtools.InitializationScript;
import aquality.selenium.core.localization.ILocalizedLogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.events.CdpEventTypes;
import org.openqa.selenium.devtools.events.ConsoleEvent;
import org.openqa.selenium.devtools.events.DomMutationEvent;
import org.openqa.selenium.devtools.idealized.Events;
import org.openqa.selenium.devtools.idealized.Javascript;
import org.openqa.selenium.devtools.idealized.ScriptId;
import org.openqa.selenium.devtools.v85.page.Page;
import org.openqa.selenium.devtools.v85.page.model.ScriptIdentifier;
import org.openqa.selenium.devtools.v85.runtime.Runtime;
import org.openqa.selenium.logging.EventType;
import org.openqa.selenium.logging.HasLogEvents;
import org.openqa.selenium.remote.Augmenter;

public class JavaScriptHandling {
    private final DevToolsHandling tools;
    private final Javascript<?, ?> engine;
    private final Events<?, ?> events;
    private final ILocalizedLogger logger = AqualityServices.getLocalizedLogger();
    private final Set<String> bindings = new HashSet<String>();
    private final Set<InitializationScript> initializationScripts = new HashSet<InitializationScript>();

    public JavaScriptHandling(DevToolsHandling tools) {
        this.tools = tools;
        this.engine = tools.getDevToolsSession().getDomains().javascript();
        this.events = tools.getDevToolsSession().getDomains().events();
    }

    public void addScriptCallbackBinding(String scriptName) {
        this.logger.info("loc.browser.javascript.scriptcallbackbinding.add", new Object[]{scriptName});
        this.bindings.add(scriptName);
        this.tools.sendCommand(Runtime.addBinding((String)scriptName, Optional.empty()));
    }

    public void removeScriptCallbackBinding(String scriptName) {
        this.logger.info("loc.browser.javascript.scriptcallbackbinding.remove", new Object[]{scriptName});
        this.bindings.remove(scriptName);
        this.tools.sendCommand(Runtime.removeBinding((String)scriptName));
    }

    public List<String> getScriptCallbackBindings() {
        this.logger.info("loc.browser.javascript.scriptcallbackbindings.get", new Object[0]);
        return new ArrayList<String>(this.bindings);
    }

    public void clearScriptCallbackBindings() {
        this.logger.info("loc.browser.javascript.scriptcallbackbindings.clear", new Object[0]);
        this.bindings.forEach(scriptName -> {
            this.bindings.remove(scriptName);
            this.tools.sendCommand(Runtime.removeBinding((String)scriptName));
        });
    }

    public InitializationScript addInitializationScript(String scriptName, String script) {
        this.logger.info("loc.browser.javascript.initializationscript.add", new Object[]{scriptName});
        this.logger.info("loc.browser.javascript.scriptcallbackbinding.add", new Object[]{scriptName});
        ScriptId scriptId = this.engine.pin(scriptName, script);
        InitializationScript initializationScript = new InitializationScript(scriptId, scriptName, script);
        this.bindings.add(scriptName);
        this.initializationScripts.add(initializationScript);
        return initializationScript;
    }

    private void removeInitializationScriptCore(InitializationScript script) {
        this.tools.sendCommand(Page.removeScriptToEvaluateOnNewDocument((ScriptIdentifier)new ScriptIdentifier(script.getScriptId().getActualId().toString())));
        try {
            Field pinnedScripts = Javascript.class.getDeclaredField("pinnedScripts");
            pinnedScripts.setAccessible(true);
            ((Map)((Map)pinnedScripts.get(this.engine)).get(this.tools.getDevToolsSession().getCdpSession())).remove(script.getScriptSource());
            pinnedScripts.setAccessible(false);
        }
        catch (ReflectiveOperationException e) {
            AqualityServices.getLogger().fatal("Error while removing initialization script", (Throwable)e);
        }
        this.initializationScripts.remove(script);
        this.removeScriptCallbackBinding(script.getScriptName());
    }

    public void removeInitializationScript(InitializationScript script) {
        this.logger.info("loc.browser.javascript.initializationscript.remove", new Object[]{script.getScriptName()});
        this.removeInitializationScriptCore(script);
    }

    public List<InitializationScript> getInitializationScripts() {
        this.logger.info("loc.browser.javascript.initializationscripts.get", new Object[0]);
        return new ArrayList<InitializationScript>(this.initializationScripts);
    }

    public void clearInitializationScripts() {
        this.logger.info("loc.browser.javascript.initializationscripts.clear", new Object[0]);
        this.initializationScripts.forEach(this::removeInitializationScriptCore);
    }

    private JavascriptExecutor getJavascriptExecutor() {
        return (JavascriptExecutor)this.tools.getDevToolsProvider();
    }

    public ScriptKey pinScript(String script) {
        this.logger.info("loc.browser.javascript.snippet.pin", new Object[0]);
        return this.getJavascriptExecutor().pin(script);
    }

    public void unpinScript(ScriptKey pinnedScript) {
        this.logger.info("loc.browser.javascript.snippet.unpin", new Object[0]);
        this.getJavascriptExecutor().unpin(pinnedScript);
    }

    public Set<ScriptKey> getPinnedScripts() {
        this.logger.info("loc.browser.javascript.snippets.get", new Object[0]);
        return this.getJavascriptExecutor().getPinnedScripts();
    }

    public void clearPinnedScripts() {
        this.logger.info("loc.browser.javascript.snippets.clear", new Object[0]);
        this.getJavascriptExecutor().getPinnedScripts().forEach(arg_0 -> ((JavascriptExecutor)this.getJavascriptExecutor()).unpin(arg_0));
    }

    public void startEventMonitoring() {
        this.logger.info("loc.browser.javascript.event.monitoring.start", new Object[0]);
        this.tools.sendCommand(Runtime.enable());
    }

    public void stopEventMonitoring() {
        this.logger.info("loc.browser.javascript.event.monitoring.stop", new Object[0]);
        this.events.disable();
    }

    public void addBindingCalledListener(Consumer<String> listener) {
        this.logger.info("loc.browser.javascript.event.callbackexecuted.add", new Object[0]);
        this.engine.addBindingCalledListener(listener);
    }

    private HasLogEvents getDriverThatHasLogEvents() {
        String browserName;
        Augmenter augmenter;
        WebDriver driver = (WebDriver)this.tools.getDevToolsProvider();
        if (!(driver instanceof HasLogEvents) && !((driver = (augmenter = new Augmenter()).addDriverAugmentation(browserName = AqualityServices.getBrowserProfile().getBrowserName().name().toLowerCase(), HasLogEvents.class, (caps, exec) -> new HasLogEvents(){

            public <X> void onLogEvent(EventType<X> kind) {
                kind.initializeListener((WebDriver)JavaScriptHandling.this.tools.getDevToolsProvider());
            }
        }).augment(driver)) instanceof HasLogEvents)) {
            throw new UnsupportedOperationException(String.format("Driver for the current browser [%s] doesn't implement HasLogEvents", browserName));
        }
        return (HasLogEvents)driver;
    }

    public void addDomMutatedListener(Consumer<DomMutationEvent> listener) {
        this.logger.info("loc.browser.javascript.event.dommutated.add", new Object[0]);
        this.getDriverThatHasLogEvents().onLogEvent(CdpEventTypes.domMutation(listener));
    }

    public void addJavaScriptConsoleApiListener(Consumer<ConsoleEvent> listener) {
        this.logger.info("loc.browser.javascript.event.consoleapicalled.add", new Object[0]);
        this.events.addConsoleListener(listener);
    }

    public void addJavaScriptExceptionThrownListener(Consumer<JavascriptException> listener) {
        this.logger.info("loc.browser.javascript.event.exceptionthrown.add", new Object[0]);
        this.events.addJavascriptExceptionListener(listener);
    }

    public void clearAll() {
        this.logger.info("loc.browser.javascript.clearall", new Object[0]);
        this.clearInitializationScripts();
        this.clearScriptCallbackBindings();
    }

    public void reset() {
        this.logger.info("loc.browser.javascript.reset", new Object[0]);
        this.engine.disable();
        this.clearInitializationScripts();
        this.clearScriptCallbackBindings();
    }
}

